/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeAdvanceUsage;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_EMPLOYEE_ADVANCE", indexes={@Index(columnList="employee"), @Index(columnList="payment_mode")})
public class EmployeeAdvance
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_ADVANCE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_ADVANCE_SEQ", sequenceName="HR_EMPLOYEE_ADVANCE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Type", selection="hr.employee.advance.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Requested amount")
    private BigDecimal requestedAmount = BigDecimal.ZERO;
    @Widget(title="Remaining amount")
    private BigDecimal remainingAmount = BigDecimal.ZERO;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Reason")
    private String reason;
    @Widget(title="Status", readonly=true, selection="hr.employee.advance.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Employee advance usage")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employeeAdvance", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmployeeAdvanceUsage> employeeAdvanceUsageList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public BigDecimal getRequestedAmount() {
        return this.requestedAmount == null ? BigDecimal.ZERO : this.requestedAmount;
    }

    public void setRequestedAmount(BigDecimal requestedAmount) {
        this.requestedAmount = requestedAmount;
    }

    public BigDecimal getRemainingAmount() {
        return this.remainingAmount == null ? BigDecimal.ZERO : this.remainingAmount;
    }

    public void setRemainingAmount(BigDecimal remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public List<EmployeeAdvanceUsage> getEmployeeAdvanceUsageList() {
        return this.employeeAdvanceUsageList;
    }

    public void setEmployeeAdvanceUsageList(List<EmployeeAdvanceUsage> employeeAdvanceUsageList) {
        this.employeeAdvanceUsageList = employeeAdvanceUsageList;
    }

    public void addEmployeeAdvanceUsageListItem(EmployeeAdvanceUsage item) {
        if (this.getEmployeeAdvanceUsageList() == null) {
            this.setEmployeeAdvanceUsageList(new ArrayList<EmployeeAdvanceUsage>());
        }
        this.getEmployeeAdvanceUsageList().add(item);
        item.setEmployeeAdvance(this);
    }

    public void removeEmployeeAdvanceUsageListItem(EmployeeAdvanceUsage item) {
        if (this.getEmployeeAdvanceUsageList() == null) {
            return;
        }
        this.getEmployeeAdvanceUsageList().remove((Object)item);
    }

    public void clearEmployeeAdvanceUsageList() {
        if (this.getEmployeeAdvanceUsageList() != null) {
            this.getEmployeeAdvanceUsageList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeAdvance)) {
            return false;
        }
        EmployeeAdvance other = (EmployeeAdvance)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("typeSelect", (Object)this.getTypeSelect()).add("requestedAmount", (Object)this.getRequestedAmount()).add("remainingAmount", (Object)this.getRemainingAmount()).add("reason", (Object)this.getReason()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

