/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.EmployeeAdvance;
import com.axelor.apps.hr.db.Expense;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_EMPLOYEE_ADVANCE_USAGE", indexes={@Index(columnList="expense"), @Index(columnList="employee_advance")})
public class EmployeeAdvanceUsage
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_ADVANCE_USAGE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_ADVANCE_USAGE_SEQ", sequenceName="HR_EMPLOYEE_ADVANCE_USAGE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Used amount")
    private BigDecimal usedAmount = BigDecimal.ZERO;
    @Widget(title="Expense")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Expense expense;
    @Widget(title="Advance")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmployeeAdvance employeeAdvance;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getUsedAmount() {
        return this.usedAmount == null ? BigDecimal.ZERO : this.usedAmount;
    }

    public void setUsedAmount(BigDecimal usedAmount) {
        this.usedAmount = usedAmount;
    }

    public Expense getExpense() {
        return this.expense;
    }

    public void setExpense(Expense expense) {
        this.expense = expense;
    }

    public EmployeeAdvance getEmployeeAdvance() {
        return this.employeeAdvance;
    }

    public void setEmployeeAdvance(EmployeeAdvance employeeAdvance) {
        this.employeeAdvance = employeeAdvance;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeAdvanceUsage)) {
            return false;
        }
        EmployeeAdvanceUsage other = (EmployeeAdvanceUsage)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("usedAmount", (Object)this.getUsedAmount()).omitNullValues().toString();
    }
}

