/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_EMPLOYEE_BONUS_TYPE", indexes={@Index(columnList="code"), @Index(columnList="label")})
public class EmployeeBonusType
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_BONUS_TYPE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_BONUS_TYPE_SEQ", sequenceName="HR_EMPLOYEE_BONUS_TYPE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    private String code;
    @Widget(title="Label")
    @NameColumn
    private String label;
    @Widget(title="Application condition")
    private String applicationCondition;
    @Widget(title="Formula")
    private String formula;
    @Widget(title="Export for payroll preparation")
    private Boolean payrollPreparationExport = Boolean.FALSE;
    @Widget(title="Export code")
    private String exportCode;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EmployeeBonusType() {
    }

    public EmployeeBonusType(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getApplicationCondition() {
        return this.applicationCondition;
    }

    public void setApplicationCondition(String applicationCondition) {
        this.applicationCondition = applicationCondition;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Boolean getPayrollPreparationExport() {
        return this.payrollPreparationExport == null ? Boolean.FALSE : this.payrollPreparationExport;
    }

    public void setPayrollPreparationExport(Boolean payrollPreparationExport) {
        this.payrollPreparationExport = payrollPreparationExport;
    }

    public String getExportCode() {
        return this.exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeBonusType)) {
            return false;
        }
        EmployeeBonusType other = (EmployeeBonusType)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("label", (Object)this.getLabel()).add("applicationCondition", (Object)this.getApplicationCondition()).add("formula", (Object)this.getFormula()).add("payrollPreparationExport", (Object)this.getPayrollPreparationExport()).add("exportCode", (Object)this.getExportCode()).omitNullValues().toString();
    }
}

