/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.db.converters.EncryptedBytesConverter;
import com.axelor.db.converters.EncryptedStringConverter;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_EMPLOYEE_VEHICLE", indexes={@Index(columnList="employee"), @Index(columnList="plateNo"), @Index(columnList="kilometric_allow_param")})
public class EmployeeVehicle
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_VEHICLE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_VEHICLE_SEQ", sequenceName="HR_EMPLOYEE_VEHICLE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Vehicle Make")
    private String vehicleMake;
    @Widget(title="Vehicle Model")
    private String vehicleModel;
    @Widget(title="Plate Number")
    @NameColumn
    @Convert(converter=EncryptedStringConverter.class)
    private String plateNo;
    @Widget(title="Kilometric Allowance Param")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private KilometricAllowParam kilometricAllowParam;
    @Widget(title="Start Date")
    private LocalDate startDate;
    @Widget(title="End Date")
    private LocalDate endDate;
    @Widget(title="Registration certificate")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Convert(converter=EncryptedBytesConverter.class)
    private byte[] vehicleRegistrationCertificate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getVehicleMake() {
        return this.vehicleMake;
    }

    public void setVehicleMake(String vehicleMake) {
        this.vehicleMake = vehicleMake;
    }

    public String getVehicleModel() {
        return this.vehicleModel;
    }

    public void setVehicleModel(String vehicleModel) {
        this.vehicleModel = vehicleModel;
    }

    public String getPlateNo() {
        return this.plateNo;
    }

    public void setPlateNo(String plateNo) {
        this.plateNo = plateNo;
    }

    public KilometricAllowParam getKilometricAllowParam() {
        return this.kilometricAllowParam;
    }

    public void setKilometricAllowParam(KilometricAllowParam kilometricAllowParam) {
        this.kilometricAllowParam = kilometricAllowParam;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public byte[] getVehicleRegistrationCertificate() {
        return this.vehicleRegistrationCertificate;
    }

    public void setVehicleRegistrationCertificate(byte[] vehicleRegistrationCertificate) {
        this.vehicleRegistrationCertificate = vehicleRegistrationCertificate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeVehicle)) {
            return false;
        }
        EmployeeVehicle other = (EmployeeVehicle)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("vehicleMake", (Object)this.getVehicleMake()).add("vehicleModel", (Object)this.getVehicleModel()).add("plateNo", (Object)this.getPlateNo()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).omitNullValues().toString();
    }
}

