/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.hr.db.KilometricAllowanceRate;
import com.axelor.apps.hr.db.LeaveManagementBatchRule;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_HR_CONFIG", indexes={@Index(columnList="kilometric_expense_product"), @Index(columnList="to_justify_leave_reason"), @Index(columnList="supplier_lunch_voucher"), @Index(columnList="sent_leave_template"), @Index(columnList="validated_leave_template"), @Index(columnList="refused_leave_template"), @Index(columnList="canceled_leave_template"), @Index(columnList="public_holiday_events_planning"), @Index(columnList="weekly_planning"), @Index(columnList="sent_timesheet_template"), @Index(columnList="validated_timesheet_template"), @Index(columnList="refused_timesheet_template"), @Index(columnList="canceled_timesheet_template"), @Index(columnList="sent_expense_template"), @Index(columnList="validated_expense_template"), @Index(columnList="refused_expense_template"), @Index(columnList="canceled_expense_template"), @Index(columnList="expense_sequence"), @Index(columnList="sent_extra_hours_template"), @Index(columnList="validated_extra_hours_template"), @Index(columnList="refused_extra_hours_template"), @Index(columnList="canceled_extra_hours_template"), @Index(columnList="unique_timesheet_product"), @Index(columnList="health_service_address")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="kilometricExpenseProduct", on={TrackEvent.UPDATE}), @TrackField(name="lunchVoucherWageShare", on={TrackEvent.UPDATE}), @TrackField(name="lunchVoucherEmployersShare", on={TrackEvent.UPDATE}), @TrackField(name="toJustifyLeaveReason", on={TrackEvent.UPDATE}), @TrackField(name="exportCodeForExtraHours", on={TrackEvent.UPDATE}), @TrackField(name="minStockLunchVoucher", on={TrackEvent.UPDATE}), @TrackField(name="availableStockLunchVoucher", on={TrackEvent.UPDATE}), @TrackField(name="supplierLunchVoucher", on={TrackEvent.UPDATE}), @TrackField(name="lunchVoucherFormatSelect", on={TrackEvent.UPDATE}), @TrackField(name="exportCodeForLunchVoucherManagement", on={TrackEvent.UPDATE}), @TrackField(name="leaveMailNotification", on={TrackEvent.UPDATE}), @TrackField(name="sentLeaveTemplate", on={TrackEvent.UPDATE}), @TrackField(name="validatedLeaveTemplate", on={TrackEvent.UPDATE}), @TrackField(name="refusedLeaveTemplate", on={TrackEvent.UPDATE}), @TrackField(name="canceledLeaveTemplate", on={TrackEvent.UPDATE}), @TrackField(name="publicHolidayEventsPlanning", on={TrackEvent.UPDATE}), @TrackField(name="weeklyPlanning", on={TrackEvent.UPDATE}), @TrackField(name="timesheetMailNotification", on={TrackEvent.UPDATE}), @TrackField(name="sentTimesheetTemplate", on={TrackEvent.UPDATE}), @TrackField(name="validatedTimesheetTemplate", on={TrackEvent.UPDATE}), @TrackField(name="refusedTimesheetTemplate", on={TrackEvent.UPDATE}), @TrackField(name="canceledTimesheetTemplate", on={TrackEvent.UPDATE}), @TrackField(name="expenseMailNotification", on={TrackEvent.UPDATE}), @TrackField(name="sentExpenseTemplate", on={TrackEvent.UPDATE}), @TrackField(name="validatedExpenseTemplate", on={TrackEvent.UPDATE}), @TrackField(name="refusedExpenseTemplate", on={TrackEvent.UPDATE}), @TrackField(name="canceledExpenseTemplate", on={TrackEvent.UPDATE}), @TrackField(name="expenseSequence", on={TrackEvent.UPDATE}), @TrackField(name="extraHoursMailNotification", on={TrackEvent.UPDATE}), @TrackField(name="sentExtraHoursTemplate", on={TrackEvent.UPDATE}), @TrackField(name="validatedExtraHoursTemplate", on={TrackEvent.UPDATE}), @TrackField(name="refusedExtraHoursTemplate", on={TrackEvent.UPDATE}), @TrackField(name="canceledExtraHoursTemplate", on={TrackEvent.UPDATE}), @TrackField(name="seniorityVariableName", on={TrackEvent.UPDATE}), @TrackField(name="ageVariableName", on={TrackEvent.UPDATE}), @TrackField(name="workingDaysVariableName", on={TrackEvent.UPDATE}), @TrackField(name="totalWorkingDaysVariableName", on={TrackEvent.UPDATE}), @TrackField(name="useUniqueProductForTimesheet", on={TrackEvent.UPDATE}), @TrackField(name="uniqueTimesheetProduct", on={TrackEvent.UPDATE})})
public class HRConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_HR_CONFIG_SEQ")
    @SequenceGenerator(name="HR_HR_CONFIG_SEQ", sequenceName="HR_HR_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Kilometric expense product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product kilometricExpenseProduct;
    @Widget(title="Lunch Voucher Wage Share")
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherWageShare = BigDecimal.ZERO;
    @Widget(title="Lunch Voucher Employer's Share")
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherEmployersShare = BigDecimal.ZERO;
    @Widget(title="Leave Reason for Leave to justify")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveReason toJustifyLeaveReason;
    @Widget(title="Export code for extra hour management")
    private String exportCodeForExtraHours;
    @Widget(title="Export code for duration")
    private String exportCodeForDuration;
    @Widget(title="Minimum Stock of Lunch Vouchers")
    private Integer minStockLunchVoucher = 0;
    @Widget(title="Available Stock of Lunch Vouchers")
    private Integer availableStockLunchVoucher = 0;
    @Widget(title="Lunch voucher supplier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierLunchVoucher;
    @Widget(title="Lunch Voucher Format", selection="hr.lunch.voucher.mgt.line.lunch.voucher.format.select")
    private Integer lunchVoucherFormatSelect = 0;
    @Widget(title="Export code for lunch voucher management")
    private String exportCodeForLunchVoucherManagement;
    @Widget(title="Leave Request Notification Mail")
    private Boolean leaveMailNotification = Boolean.FALSE;
    @Widget(title="Sent Leave Request Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template sentLeaveTemplate;
    @Widget(title="Validated Leave Request Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template validatedLeaveTemplate;
    @Widget(title="Refused Leave Request Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template refusedLeaveTemplate;
    @Widget(title="Canceled Leave Request Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template canceledLeaveTemplate;
    @Widget(title="Public Holiday Planning")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EventsPlanning publicHolidayEventsPlanning;
    @Widget(title="Weekly Planning")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlanning;
    @Widget(title="Kilometric allowance rates")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="hrConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<KilometricAllowanceRate> kilometricAllowanceRateList;
    @Widget(title="Timesheet Notification Mail")
    private Boolean timesheetMailNotification = Boolean.FALSE;
    @Widget(title="Confirmed Timesheet Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template sentTimesheetTemplate;
    @Widget(title="Validated Timesheet Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template validatedTimesheetTemplate;
    @Widget(title="Refused Timesheet Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template refusedTimesheetTemplate;
    @Widget(title="Canceled Timesheet Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template canceledTimesheetTemplate;
    @Widget(title="Expense Notification Mail")
    private Boolean expenseMailNotification = Boolean.FALSE;
    @Widget(title="Sent Expense Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template sentExpenseTemplate;
    @Widget(title="Validated Expense Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template validatedExpenseTemplate;
    @Widget(title="Refused Expense Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template refusedExpenseTemplate;
    @Widget(title="Canceled Expense Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template canceledExpenseTemplate;
    @Widget(title="Expense Sequence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence expenseSequence;
    @Widget(title="Extra Hours Notification Mail")
    private Boolean extraHoursMailNotification = Boolean.FALSE;
    @Widget(title="Confirmed Extra Hours Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template sentExtraHoursTemplate;
    @Widget(title="Validated Extra Hours Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template validatedExtraHoursTemplate;
    @Widget(title="Refused Extra Hours Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template refusedExtraHoursTemplate;
    @Widget(title="Canceled Extra Hours Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template canceledExtraHoursTemplate;
    @Widget(title="Leave management batch rule list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="hrConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LeaveManagementBatchRule> leaveManagementBatchRuleList;
    @Widget(title="Name for seniority variable")
    private String seniorityVariableName;
    @Widget(title="Name for age variable")
    private String ageVariableName;
    @Widget(title="Name for working day variable")
    private String workingDaysVariableName;
    @Widget(title="Name for total working day in a period variable")
    private String totalWorkingDaysVariableName;
    @Widget(title="Use unique product for timesheet")
    private Boolean useUniqueProductForTimesheet = Boolean.FALSE;
    @Widget(title="Unique product for timesheet")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product uniqueTimesheetProduct;
    @Widget(title="Enable DPAE")
    private Boolean enableDPAE = Boolean.FALSE;
    @Widget(title="Health service")
    private String healthService;
    @Widget(title="Health service address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address healthServiceAddress;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Product getKilometricExpenseProduct() {
        return this.kilometricExpenseProduct;
    }

    public void setKilometricExpenseProduct(Product kilometricExpenseProduct) {
        this.kilometricExpenseProduct = kilometricExpenseProduct;
    }

    public BigDecimal getLunchVoucherWageShare() {
        return this.lunchVoucherWageShare == null ? BigDecimal.ZERO : this.lunchVoucherWageShare;
    }

    public void setLunchVoucherWageShare(BigDecimal lunchVoucherWageShare) {
        this.lunchVoucherWageShare = lunchVoucherWageShare;
    }

    public BigDecimal getLunchVoucherEmployersShare() {
        return this.lunchVoucherEmployersShare == null ? BigDecimal.ZERO : this.lunchVoucherEmployersShare;
    }

    public void setLunchVoucherEmployersShare(BigDecimal lunchVoucherEmployersShare) {
        this.lunchVoucherEmployersShare = lunchVoucherEmployersShare;
    }

    public LeaveReason getToJustifyLeaveReason() {
        return this.toJustifyLeaveReason;
    }

    public void setToJustifyLeaveReason(LeaveReason toJustifyLeaveReason) {
        this.toJustifyLeaveReason = toJustifyLeaveReason;
    }

    public String getExportCodeForExtraHours() {
        return this.exportCodeForExtraHours;
    }

    public void setExportCodeForExtraHours(String exportCodeForExtraHours) {
        this.exportCodeForExtraHours = exportCodeForExtraHours;
    }

    public String getExportCodeForDuration() {
        return this.exportCodeForDuration;
    }

    public void setExportCodeForDuration(String exportCodeForDuration) {
        this.exportCodeForDuration = exportCodeForDuration;
    }

    public Integer getMinStockLunchVoucher() {
        return this.minStockLunchVoucher == null ? 0 : this.minStockLunchVoucher;
    }

    public void setMinStockLunchVoucher(Integer minStockLunchVoucher) {
        this.minStockLunchVoucher = minStockLunchVoucher;
    }

    public Integer getAvailableStockLunchVoucher() {
        return this.availableStockLunchVoucher == null ? 0 : this.availableStockLunchVoucher;
    }

    public void setAvailableStockLunchVoucher(Integer availableStockLunchVoucher) {
        this.availableStockLunchVoucher = availableStockLunchVoucher;
    }

    public Partner getSupplierLunchVoucher() {
        return this.supplierLunchVoucher;
    }

    public void setSupplierLunchVoucher(Partner supplierLunchVoucher) {
        this.supplierLunchVoucher = supplierLunchVoucher;
    }

    public Integer getLunchVoucherFormatSelect() {
        return this.lunchVoucherFormatSelect == null ? 0 : this.lunchVoucherFormatSelect;
    }

    public void setLunchVoucherFormatSelect(Integer lunchVoucherFormatSelect) {
        this.lunchVoucherFormatSelect = lunchVoucherFormatSelect;
    }

    public String getExportCodeForLunchVoucherManagement() {
        return this.exportCodeForLunchVoucherManagement;
    }

    public void setExportCodeForLunchVoucherManagement(String exportCodeForLunchVoucherManagement) {
        this.exportCodeForLunchVoucherManagement = exportCodeForLunchVoucherManagement;
    }

    public Boolean getLeaveMailNotification() {
        return this.leaveMailNotification == null ? Boolean.FALSE : this.leaveMailNotification;
    }

    public void setLeaveMailNotification(Boolean leaveMailNotification) {
        this.leaveMailNotification = leaveMailNotification;
    }

    public Template getSentLeaveTemplate() {
        return this.sentLeaveTemplate;
    }

    public void setSentLeaveTemplate(Template sentLeaveTemplate) {
        this.sentLeaveTemplate = sentLeaveTemplate;
    }

    public Template getValidatedLeaveTemplate() {
        return this.validatedLeaveTemplate;
    }

    public void setValidatedLeaveTemplate(Template validatedLeaveTemplate) {
        this.validatedLeaveTemplate = validatedLeaveTemplate;
    }

    public Template getRefusedLeaveTemplate() {
        return this.refusedLeaveTemplate;
    }

    public void setRefusedLeaveTemplate(Template refusedLeaveTemplate) {
        this.refusedLeaveTemplate = refusedLeaveTemplate;
    }

    public Template getCanceledLeaveTemplate() {
        return this.canceledLeaveTemplate;
    }

    public void setCanceledLeaveTemplate(Template canceledLeaveTemplate) {
        this.canceledLeaveTemplate = canceledLeaveTemplate;
    }

    public EventsPlanning getPublicHolidayEventsPlanning() {
        return this.publicHolidayEventsPlanning;
    }

    public void setPublicHolidayEventsPlanning(EventsPlanning publicHolidayEventsPlanning) {
        this.publicHolidayEventsPlanning = publicHolidayEventsPlanning;
    }

    public WeeklyPlanning getWeeklyPlanning() {
        return this.weeklyPlanning;
    }

    public void setWeeklyPlanning(WeeklyPlanning weeklyPlanning) {
        this.weeklyPlanning = weeklyPlanning;
    }

    public List<KilometricAllowanceRate> getKilometricAllowanceRateList() {
        return this.kilometricAllowanceRateList;
    }

    public void setKilometricAllowanceRateList(List<KilometricAllowanceRate> kilometricAllowanceRateList) {
        this.kilometricAllowanceRateList = kilometricAllowanceRateList;
    }

    public void addKilometricAllowanceRateListItem(KilometricAllowanceRate item) {
        if (this.getKilometricAllowanceRateList() == null) {
            this.setKilometricAllowanceRateList(new ArrayList<KilometricAllowanceRate>());
        }
        this.getKilometricAllowanceRateList().add(item);
        item.setHrConfig(this);
    }

    public void removeKilometricAllowanceRateListItem(KilometricAllowanceRate item) {
        if (this.getKilometricAllowanceRateList() == null) {
            return;
        }
        this.getKilometricAllowanceRateList().remove((Object)item);
    }

    public void clearKilometricAllowanceRateList() {
        if (this.getKilometricAllowanceRateList() != null) {
            this.getKilometricAllowanceRateList().clear();
        }
    }

    public Boolean getTimesheetMailNotification() {
        return this.timesheetMailNotification == null ? Boolean.FALSE : this.timesheetMailNotification;
    }

    public void setTimesheetMailNotification(Boolean timesheetMailNotification) {
        this.timesheetMailNotification = timesheetMailNotification;
    }

    public Template getSentTimesheetTemplate() {
        return this.sentTimesheetTemplate;
    }

    public void setSentTimesheetTemplate(Template sentTimesheetTemplate) {
        this.sentTimesheetTemplate = sentTimesheetTemplate;
    }

    public Template getValidatedTimesheetTemplate() {
        return this.validatedTimesheetTemplate;
    }

    public void setValidatedTimesheetTemplate(Template validatedTimesheetTemplate) {
        this.validatedTimesheetTemplate = validatedTimesheetTemplate;
    }

    public Template getRefusedTimesheetTemplate() {
        return this.refusedTimesheetTemplate;
    }

    public void setRefusedTimesheetTemplate(Template refusedTimesheetTemplate) {
        this.refusedTimesheetTemplate = refusedTimesheetTemplate;
    }

    public Template getCanceledTimesheetTemplate() {
        return this.canceledTimesheetTemplate;
    }

    public void setCanceledTimesheetTemplate(Template canceledTimesheetTemplate) {
        this.canceledTimesheetTemplate = canceledTimesheetTemplate;
    }

    public Boolean getExpenseMailNotification() {
        return this.expenseMailNotification == null ? Boolean.FALSE : this.expenseMailNotification;
    }

    public void setExpenseMailNotification(Boolean expenseMailNotification) {
        this.expenseMailNotification = expenseMailNotification;
    }

    public Template getSentExpenseTemplate() {
        return this.sentExpenseTemplate;
    }

    public void setSentExpenseTemplate(Template sentExpenseTemplate) {
        this.sentExpenseTemplate = sentExpenseTemplate;
    }

    public Template getValidatedExpenseTemplate() {
        return this.validatedExpenseTemplate;
    }

    public void setValidatedExpenseTemplate(Template validatedExpenseTemplate) {
        this.validatedExpenseTemplate = validatedExpenseTemplate;
    }

    public Template getRefusedExpenseTemplate() {
        return this.refusedExpenseTemplate;
    }

    public void setRefusedExpenseTemplate(Template refusedExpenseTemplate) {
        this.refusedExpenseTemplate = refusedExpenseTemplate;
    }

    public Template getCanceledExpenseTemplate() {
        return this.canceledExpenseTemplate;
    }

    public void setCanceledExpenseTemplate(Template canceledExpenseTemplate) {
        this.canceledExpenseTemplate = canceledExpenseTemplate;
    }

    public Sequence getExpenseSequence() {
        return this.expenseSequence;
    }

    public void setExpenseSequence(Sequence expenseSequence) {
        this.expenseSequence = expenseSequence;
    }

    public Boolean getExtraHoursMailNotification() {
        return this.extraHoursMailNotification == null ? Boolean.FALSE : this.extraHoursMailNotification;
    }

    public void setExtraHoursMailNotification(Boolean extraHoursMailNotification) {
        this.extraHoursMailNotification = extraHoursMailNotification;
    }

    public Template getSentExtraHoursTemplate() {
        return this.sentExtraHoursTemplate;
    }

    public void setSentExtraHoursTemplate(Template sentExtraHoursTemplate) {
        this.sentExtraHoursTemplate = sentExtraHoursTemplate;
    }

    public Template getValidatedExtraHoursTemplate() {
        return this.validatedExtraHoursTemplate;
    }

    public void setValidatedExtraHoursTemplate(Template validatedExtraHoursTemplate) {
        this.validatedExtraHoursTemplate = validatedExtraHoursTemplate;
    }

    public Template getRefusedExtraHoursTemplate() {
        return this.refusedExtraHoursTemplate;
    }

    public void setRefusedExtraHoursTemplate(Template refusedExtraHoursTemplate) {
        this.refusedExtraHoursTemplate = refusedExtraHoursTemplate;
    }

    public Template getCanceledExtraHoursTemplate() {
        return this.canceledExtraHoursTemplate;
    }

    public void setCanceledExtraHoursTemplate(Template canceledExtraHoursTemplate) {
        this.canceledExtraHoursTemplate = canceledExtraHoursTemplate;
    }

    public List<LeaveManagementBatchRule> getLeaveManagementBatchRuleList() {
        return this.leaveManagementBatchRuleList;
    }

    public void setLeaveManagementBatchRuleList(List<LeaveManagementBatchRule> leaveManagementBatchRuleList) {
        this.leaveManagementBatchRuleList = leaveManagementBatchRuleList;
    }

    public void addLeaveManagementBatchRuleListItem(LeaveManagementBatchRule item) {
        if (this.getLeaveManagementBatchRuleList() == null) {
            this.setLeaveManagementBatchRuleList(new ArrayList<LeaveManagementBatchRule>());
        }
        this.getLeaveManagementBatchRuleList().add(item);
        item.setHrConfig(this);
    }

    public void removeLeaveManagementBatchRuleListItem(LeaveManagementBatchRule item) {
        if (this.getLeaveManagementBatchRuleList() == null) {
            return;
        }
        this.getLeaveManagementBatchRuleList().remove((Object)item);
    }

    public void clearLeaveManagementBatchRuleList() {
        if (this.getLeaveManagementBatchRuleList() != null) {
            this.getLeaveManagementBatchRuleList().clear();
        }
    }

    public String getSeniorityVariableName() {
        return this.seniorityVariableName;
    }

    public void setSeniorityVariableName(String seniorityVariableName) {
        this.seniorityVariableName = seniorityVariableName;
    }

    public String getAgeVariableName() {
        return this.ageVariableName;
    }

    public void setAgeVariableName(String ageVariableName) {
        this.ageVariableName = ageVariableName;
    }

    public String getWorkingDaysVariableName() {
        return this.workingDaysVariableName;
    }

    public void setWorkingDaysVariableName(String workingDaysVariableName) {
        this.workingDaysVariableName = workingDaysVariableName;
    }

    public String getTotalWorkingDaysVariableName() {
        return this.totalWorkingDaysVariableName;
    }

    public void setTotalWorkingDaysVariableName(String totalWorkingDaysVariableName) {
        this.totalWorkingDaysVariableName = totalWorkingDaysVariableName;
    }

    public Boolean getUseUniqueProductForTimesheet() {
        return this.useUniqueProductForTimesheet == null ? Boolean.FALSE : this.useUniqueProductForTimesheet;
    }

    public void setUseUniqueProductForTimesheet(Boolean useUniqueProductForTimesheet) {
        this.useUniqueProductForTimesheet = useUniqueProductForTimesheet;
    }

    public Product getUniqueTimesheetProduct() {
        return this.uniqueTimesheetProduct;
    }

    public void setUniqueTimesheetProduct(Product uniqueTimesheetProduct) {
        this.uniqueTimesheetProduct = uniqueTimesheetProduct;
    }

    public Boolean getEnableDPAE() {
        return this.enableDPAE == null ? Boolean.FALSE : this.enableDPAE;
    }

    public void setEnableDPAE(Boolean enableDPAE) {
        this.enableDPAE = enableDPAE;
    }

    public String getHealthService() {
        return this.healthService;
    }

    public void setHealthService(String healthService) {
        this.healthService = healthService;
    }

    public Address getHealthServiceAddress() {
        return this.healthServiceAddress;
    }

    public void setHealthServiceAddress(Address healthServiceAddress) {
        this.healthServiceAddress = healthServiceAddress;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HRConfig)) {
            return false;
        }
        HRConfig other = (HRConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals((Object)this.getCompany(), (Object)other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{-1581774612, this.getCompany()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("lunchVoucherWageShare", (Object)this.getLunchVoucherWageShare()).add("lunchVoucherEmployersShare", (Object)this.getLunchVoucherEmployersShare()).add("exportCodeForExtraHours", (Object)this.getExportCodeForExtraHours()).add("exportCodeForDuration", (Object)this.getExportCodeForDuration()).add("minStockLunchVoucher", (Object)this.getMinStockLunchVoucher()).add("availableStockLunchVoucher", (Object)this.getAvailableStockLunchVoucher()).add("lunchVoucherFormatSelect", (Object)this.getLunchVoucherFormatSelect()).add("exportCodeForLunchVoucherManagement", (Object)this.getExportCodeForLunchVoucherManagement()).add("leaveMailNotification", (Object)this.getLeaveMailNotification()).add("timesheetMailNotification", (Object)this.getTimesheetMailNotification()).add("expenseMailNotification", (Object)this.getExpenseMailNotification()).omitNullValues().toString();
    }
}

