/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_HR_BATCH", indexes={@Index(columnList="company"), @Index(columnList="leave_reason"), @Index(columnList="period"), @Index(columnList="template")})
public class HrBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_HR_BATCH_SEQ")
    @SequenceGenerator(name="HR_HR_BATCH_SEQ", sequenceName="HR_HR_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="ihr.batch.action.select")
    @NotNull
    private Integer actionSelect = 0;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="hrBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Leave Reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveReason leaveReason;
    @Widget(title="Number of days")
    @Digits(integer=4, fraction=4)
    private BigDecimal dayNumber = BigDecimal.ZERO;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Comment")
    private String comments;
    @Widget(title="Employees")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Employee> employeeSet;
    @Widget(title="Plannings")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<WeeklyPlanning> planningSet;
    @Widget(title="Use weekly plannning coef.")
    private Boolean useWeeklyPlanningCoef = Boolean.FALSE;
    @Widget(title="Referential date for seniority")
    private LocalDate referentialDate;
    @Widget(title="Period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Export type", selection="hr.batch.payroll.preparation.export.type.select")
    private Integer payrollPreparationExportTypeSelect = 0;
    @Widget(title="Also export already exported payroll preparations")
    private Boolean exportAlreadyExported = Boolean.FALSE;
    @Widget(title="Export type", selection="hr.batch.employment.contract.export.type.select")
    private Integer employmentContractExportTypeSelect = 0;
    @Widget(title="Number of days before reminder")
    private Long daysBeforeReminder = 0L;
    @Widget(title="Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template template;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public HrBatch() {
    }

    public HrBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setHrBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public LeaveReason getLeaveReason() {
        return this.leaveReason;
    }

    public void setLeaveReason(LeaveReason leaveReason) {
        this.leaveReason = leaveReason;
    }

    public BigDecimal getDayNumber() {
        return this.dayNumber == null ? BigDecimal.ZERO : this.dayNumber;
    }

    public void setDayNumber(BigDecimal dayNumber) {
        this.dayNumber = dayNumber;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Set<Employee> getEmployeeSet() {
        return this.employeeSet;
    }

    public void setEmployeeSet(Set<Employee> employeeSet) {
        this.employeeSet = employeeSet;
    }

    public void addEmployeeSetItem(Employee item) {
        if (this.getEmployeeSet() == null) {
            this.setEmployeeSet(new HashSet<Employee>());
        }
        this.getEmployeeSet().add(item);
    }

    public void removeEmployeeSetItem(Employee item) {
        if (this.getEmployeeSet() == null) {
            return;
        }
        this.getEmployeeSet().remove((Object)item);
    }

    public void clearEmployeeSet() {
        if (this.getEmployeeSet() != null) {
            this.getEmployeeSet().clear();
        }
    }

    public Set<WeeklyPlanning> getPlanningSet() {
        return this.planningSet;
    }

    public void setPlanningSet(Set<WeeklyPlanning> planningSet) {
        this.planningSet = planningSet;
    }

    public void addPlanningSetItem(WeeklyPlanning item) {
        if (this.getPlanningSet() == null) {
            this.setPlanningSet(new HashSet<WeeklyPlanning>());
        }
        this.getPlanningSet().add(item);
    }

    public void removePlanningSetItem(WeeklyPlanning item) {
        if (this.getPlanningSet() == null) {
            return;
        }
        this.getPlanningSet().remove(item);
    }

    public void clearPlanningSet() {
        if (this.getPlanningSet() != null) {
            this.getPlanningSet().clear();
        }
    }

    public Boolean getUseWeeklyPlanningCoef() {
        return this.useWeeklyPlanningCoef == null ? Boolean.FALSE : this.useWeeklyPlanningCoef;
    }

    public void setUseWeeklyPlanningCoef(Boolean useWeeklyPlanningCoef) {
        this.useWeeklyPlanningCoef = useWeeklyPlanningCoef;
    }

    public LocalDate getReferentialDate() {
        return this.referentialDate;
    }

    public void setReferentialDate(LocalDate referentialDate) {
        this.referentialDate = referentialDate;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Integer getPayrollPreparationExportTypeSelect() {
        return this.payrollPreparationExportTypeSelect == null ? 0 : this.payrollPreparationExportTypeSelect;
    }

    public void setPayrollPreparationExportTypeSelect(Integer payrollPreparationExportTypeSelect) {
        this.payrollPreparationExportTypeSelect = payrollPreparationExportTypeSelect;
    }

    public Boolean getExportAlreadyExported() {
        return this.exportAlreadyExported == null ? Boolean.FALSE : this.exportAlreadyExported;
    }

    public void setExportAlreadyExported(Boolean exportAlreadyExported) {
        this.exportAlreadyExported = exportAlreadyExported;
    }

    public Integer getEmploymentContractExportTypeSelect() {
        return this.employmentContractExportTypeSelect == null ? 0 : this.employmentContractExportTypeSelect;
    }

    public void setEmploymentContractExportTypeSelect(Integer employmentContractExportTypeSelect) {
        this.employmentContractExportTypeSelect = employmentContractExportTypeSelect;
    }

    public Long getDaysBeforeReminder() {
        return this.daysBeforeReminder == null ? 0L : this.daysBeforeReminder;
    }

    public void setDaysBeforeReminder(Long daysBeforeReminder) {
        this.daysBeforeReminder = daysBeforeReminder;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HrBatch)) {
            return false;
        }
        HrBatch other = (HrBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-1491531728, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("dayNumber", (Object)this.getDayNumber()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).add("comments", (Object)this.getComments()).add("useWeeklyPlanningCoef", (Object)this.getUseWeeklyPlanningCoef()).add("referentialDate", (Object)this.getReferentialDate()).add("payrollPreparationExportTypeSelect", (Object)this.getPayrollPreparationExportTypeSelect()).add("exportAlreadyExported", (Object)this.getExportAlreadyExported()).add("employmentContractExportTypeSelect", (Object)this.getEmploymentContractExportTypeSelect()).omitNullValues().toString();
    }
}

