/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.hr.db.KilometricAllowanceRule;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_KILOMETRIC_ALLOWANCE_RATE", indexes={@Index(columnList="hr_config"), @Index(columnList="kilometric_allow_param")})
public class KilometricAllowanceRate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_KILOMETRIC_ALLOWANCE_RATE_SEQ")
    @SequenceGenerator(name="HR_KILOMETRIC_ALLOWANCE_RATE_SEQ", sequenceName="HR_KILOMETRIC_ALLOWANCE_RATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="HrConfig")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private HRConfig hrConfig;
    @Widget(title="Kilometric Allowance Param")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private KilometricAllowParam kilometricAllowParam;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="kilometricAllowanceRate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<KilometricAllowanceRule> kilometricAllowanceRuleList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HRConfig getHrConfig() {
        return this.hrConfig;
    }

    public void setHrConfig(HRConfig hrConfig) {
        this.hrConfig = hrConfig;
    }

    public KilometricAllowParam getKilometricAllowParam() {
        return this.kilometricAllowParam;
    }

    public void setKilometricAllowParam(KilometricAllowParam kilometricAllowParam) {
        this.kilometricAllowParam = kilometricAllowParam;
    }

    public List<KilometricAllowanceRule> getKilometricAllowanceRuleList() {
        return this.kilometricAllowanceRuleList;
    }

    public void setKilometricAllowanceRuleList(List<KilometricAllowanceRule> kilometricAllowanceRuleList) {
        this.kilometricAllowanceRuleList = kilometricAllowanceRuleList;
    }

    public void addKilometricAllowanceRuleListItem(KilometricAllowanceRule item) {
        if (this.getKilometricAllowanceRuleList() == null) {
            this.setKilometricAllowanceRuleList(new ArrayList<KilometricAllowanceRule>());
        }
        this.getKilometricAllowanceRuleList().add(item);
        item.setKilometricAllowanceRate(this);
    }

    public void removeKilometricAllowanceRuleListItem(KilometricAllowanceRule item) {
        if (this.getKilometricAllowanceRuleList() == null) {
            return;
        }
        this.getKilometricAllowanceRuleList().remove((Object)item);
    }

    public void clearKilometricAllowanceRuleList() {
        if (this.getKilometricAllowanceRuleList() != null) {
            this.getKilometricAllowanceRuleList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KilometricAllowanceRate)) {
            return false;
        }
        KilometricAllowanceRate other = (KilometricAllowanceRate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

