/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LEAVE_REASON", indexes={@Index(columnList="leaveReason")})
public class LeaveReason
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LEAVE_REASON_SEQ")
    @SequenceGenerator(name="HR_LEAVE_REASON_SEQ", sequenceName="HR_LEAVE_REASON_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Leave reason")
    @NameColumn
    @NotNull
    private String leaveReason;
    @Widget(title="Manage Accumulation")
    private Boolean manageAccumulation = Boolean.FALSE;
    @Widget(title="Allow negative value for leaves")
    private Boolean allowNegativeValue = Boolean.FALSE;
    @Widget(title="Allow Injection")
    private Boolean allowInjection = Boolean.FALSE;
    @Widget(title="Instruction", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String instruction;
    @Widget(title="Export for payroll preparation")
    private Boolean payrollPreprationExport = Boolean.FALSE;
    @Widget(title="Export code")
    private String exportCode;
    @Widget(title="Default day number gain")
    private BigDecimal defaultDayNumberGain = BigDecimal.ZERO;
    @Widget(title="Can only be selected by HR Management")
    private Boolean selectedByMgtOnly = Boolean.FALSE;
    @Widget(title="Unit", selection="hr.leave.reason.unit.select")
    private Integer unitSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLeaveReason() {
        return this.leaveReason;
    }

    public void setLeaveReason(String leaveReason) {
        this.leaveReason = leaveReason;
    }

    public Boolean getManageAccumulation() {
        return this.manageAccumulation == null ? Boolean.FALSE : this.manageAccumulation;
    }

    public void setManageAccumulation(Boolean manageAccumulation) {
        this.manageAccumulation = manageAccumulation;
    }

    public Boolean getAllowNegativeValue() {
        return this.allowNegativeValue == null ? Boolean.FALSE : this.allowNegativeValue;
    }

    public void setAllowNegativeValue(Boolean allowNegativeValue) {
        this.allowNegativeValue = allowNegativeValue;
    }

    public Boolean getAllowInjection() {
        return this.allowInjection == null ? Boolean.FALSE : this.allowInjection;
    }

    public void setAllowInjection(Boolean allowInjection) {
        this.allowInjection = allowInjection;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public Boolean getPayrollPreprationExport() {
        return this.payrollPreprationExport == null ? Boolean.FALSE : this.payrollPreprationExport;
    }

    public void setPayrollPreprationExport(Boolean payrollPreprationExport) {
        this.payrollPreprationExport = payrollPreprationExport;
    }

    public String getExportCode() {
        return this.exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public BigDecimal getDefaultDayNumberGain() {
        return this.defaultDayNumberGain == null ? BigDecimal.ZERO : this.defaultDayNumberGain;
    }

    public void setDefaultDayNumberGain(BigDecimal defaultDayNumberGain) {
        this.defaultDayNumberGain = defaultDayNumberGain;
    }

    public Boolean getSelectedByMgtOnly() {
        return this.selectedByMgtOnly == null ? Boolean.FALSE : this.selectedByMgtOnly;
    }

    public void setSelectedByMgtOnly(Boolean selectedByMgtOnly) {
        this.selectedByMgtOnly = selectedByMgtOnly;
    }

    public Integer getUnitSelect() {
        return this.unitSelect == null ? 0 : this.unitSelect;
    }

    public void setUnitSelect(Integer unitSelect) {
        this.unitSelect = unitSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeaveReason)) {
            return false;
        }
        LeaveReason other = (LeaveReason)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("leaveReason", (Object)this.getLeaveReason()).add("manageAccumulation", (Object)this.getManageAccumulation()).add("allowNegativeValue", (Object)this.getAllowNegativeValue()).add("allowInjection", (Object)this.getAllowInjection()).add("payrollPreprationExport", (Object)this.getPayrollPreprationExport()).add("exportCode", (Object)this.getExportCode()).add("defaultDayNumberGain", (Object)this.getDefaultDayNumberGain()).add("selectedByMgtOnly", (Object)this.getSelectedByMgtOnly()).add("unitSelect", (Object)this.getUnitSelect()).omitNullValues().toString();
    }
}

