/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LUNCH_VOUCHER_ADVANCE", indexes={@Index(columnList="employee")})
public class LunchVoucherAdvance
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LUNCH_VOUCHER_ADVANCE_SEQ")
    @SequenceGenerator(name="HR_LUNCH_VOUCHER_ADVANCE_SEQ", sequenceName="HR_LUNCH_VOUCHER_ADVANCE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Distribution date")
    private LocalDate distributionDate;
    @Widget(title="Lunch vouchers distributed")
    @Min(value=1L)
    private Integer nbrLunchVouchers = 0;
    @Widget(title="Lunch vouchers used")
    @Min(value=0L)
    private Integer nbrLunchVouchersUsed = 0;
    @Widget(title="Lunch Voucher Wage Share", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherWageShare = BigDecimal.ZERO;
    @Widget(title="Lunch Voucher Employer's Share", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherEmployersShare = BigDecimal.ZERO;
    @Widget(title="Comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getDistributionDate() {
        return this.distributionDate;
    }

    public void setDistributionDate(LocalDate distributionDate) {
        this.distributionDate = distributionDate;
    }

    public Integer getNbrLunchVouchers() {
        return this.nbrLunchVouchers == null ? 0 : this.nbrLunchVouchers;
    }

    public void setNbrLunchVouchers(Integer nbrLunchVouchers) {
        this.nbrLunchVouchers = nbrLunchVouchers;
    }

    public Integer getNbrLunchVouchersUsed() {
        return this.nbrLunchVouchersUsed == null ? 0 : this.nbrLunchVouchersUsed;
    }

    public void setNbrLunchVouchersUsed(Integer nbrLunchVouchersUsed) {
        this.nbrLunchVouchersUsed = nbrLunchVouchersUsed;
    }

    public BigDecimal getLunchVoucherWageShare() {
        return this.lunchVoucherWageShare == null ? BigDecimal.ZERO : this.lunchVoucherWageShare;
    }

    public void setLunchVoucherWageShare(BigDecimal lunchVoucherWageShare) {
        this.lunchVoucherWageShare = lunchVoucherWageShare;
    }

    public BigDecimal getLunchVoucherEmployersShare() {
        return this.lunchVoucherEmployersShare == null ? BigDecimal.ZERO : this.lunchVoucherEmployersShare;
    }

    public void setLunchVoucherEmployersShare(BigDecimal lunchVoucherEmployersShare) {
        this.lunchVoucherEmployersShare = lunchVoucherEmployersShare;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LunchVoucherAdvance)) {
            return false;
        }
        LunchVoucherAdvance other = (LunchVoucherAdvance)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("distributionDate", (Object)this.getDistributionDate()).add("nbrLunchVouchers", (Object)this.getNbrLunchVouchers()).add("nbrLunchVouchersUsed", (Object)this.getNbrLunchVouchersUsed()).add("lunchVoucherWageShare", (Object)this.getLunchVoucherWageShare()).add("lunchVoucherEmployersShare", (Object)this.getLunchVoucherEmployersShare()).omitNullValues().toString();
    }
}

