/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.hr.db.LunchVoucherMgtLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LUNCH_VOUCHER_MGT", indexes={@Index(columnList="company"), @Index(columnList="pay_period"), @Index(columnList="leave_period"), @Index(columnList="csv_file")})
public class LunchVoucherMgt
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LUNCH_VOUCHER_MGT_SEQ")
    @SequenceGenerator(name="HR_LUNCH_VOUCHER_MGT_SEQ", sequenceName="HR_LUNCH_VOUCHER_MGT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Pay period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period payPeriod;
    @Widget(title="Leave period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period leavePeriod;
    @Widget(title="Status", readonly=true, selection="hrs.lunch.voucher.mgt.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Requested lunch vouchers on the period", readonly=true)
    private Integer requestedLunchVouchers = 0;
    @Widget(title="Total lunch vouchers", readonly=true)
    private Integer totalLunchVouchers = 0;
    @Widget(title="Given lunch vouchers on the period", readonly=true)
    private Integer givenLunchVouchers = 0;
    @Widget(title="Lunch Voucher Wage Share", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherWageShare = BigDecimal.ZERO;
    @Widget(title="Lunch Voucher Employer's Share", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal lunchVoucherEmployersShare = BigDecimal.ZERO;
    @Widget(title="Lunch Voucher Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="lunchVoucherMgt", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LunchVoucherMgtLine> lunchVoucherMgtLineList;
    @Widget(title="Stock quantity status", readonly=true)
    private Integer stockQuantityStatus = 0;
    @Widget(title="Quantity")
    @Min(value=0L)
    private Integer stockLineQuantity = 0;
    @Widget(title="Comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String stockLineComment;
    @Widget(title="Export date")
    private LocalDate exportDate;
    @Widget(title="CSV")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile csvFile;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Period getPayPeriod() {
        return this.payPeriod;
    }

    public void setPayPeriod(Period payPeriod) {
        this.payPeriod = payPeriod;
    }

    public Period getLeavePeriod() {
        return this.leavePeriod;
    }

    public void setLeavePeriod(Period leavePeriod) {
        this.leavePeriod = leavePeriod;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getRequestedLunchVouchers() {
        return this.requestedLunchVouchers == null ? 0 : this.requestedLunchVouchers;
    }

    public void setRequestedLunchVouchers(Integer requestedLunchVouchers) {
        this.requestedLunchVouchers = requestedLunchVouchers;
    }

    public Integer getTotalLunchVouchers() {
        return this.totalLunchVouchers == null ? 0 : this.totalLunchVouchers;
    }

    public void setTotalLunchVouchers(Integer totalLunchVouchers) {
        this.totalLunchVouchers = totalLunchVouchers;
    }

    public Integer getGivenLunchVouchers() {
        return this.givenLunchVouchers == null ? 0 : this.givenLunchVouchers;
    }

    public void setGivenLunchVouchers(Integer givenLunchVouchers) {
        this.givenLunchVouchers = givenLunchVouchers;
    }

    public BigDecimal getLunchVoucherWageShare() {
        return this.lunchVoucherWageShare == null ? BigDecimal.ZERO : this.lunchVoucherWageShare;
    }

    public void setLunchVoucherWageShare(BigDecimal lunchVoucherWageShare) {
        this.lunchVoucherWageShare = lunchVoucherWageShare;
    }

    public BigDecimal getLunchVoucherEmployersShare() {
        return this.lunchVoucherEmployersShare == null ? BigDecimal.ZERO : this.lunchVoucherEmployersShare;
    }

    public void setLunchVoucherEmployersShare(BigDecimal lunchVoucherEmployersShare) {
        this.lunchVoucherEmployersShare = lunchVoucherEmployersShare;
    }

    public List<LunchVoucherMgtLine> getLunchVoucherMgtLineList() {
        return this.lunchVoucherMgtLineList;
    }

    public void setLunchVoucherMgtLineList(List<LunchVoucherMgtLine> lunchVoucherMgtLineList) {
        this.lunchVoucherMgtLineList = lunchVoucherMgtLineList;
    }

    public void addLunchVoucherMgtLineListItem(LunchVoucherMgtLine item) {
        if (this.getLunchVoucherMgtLineList() == null) {
            this.setLunchVoucherMgtLineList(new ArrayList<LunchVoucherMgtLine>());
        }
        this.getLunchVoucherMgtLineList().add(item);
        item.setLunchVoucherMgt(this);
    }

    public void removeLunchVoucherMgtLineListItem(LunchVoucherMgtLine item) {
        if (this.getLunchVoucherMgtLineList() == null) {
            return;
        }
        this.getLunchVoucherMgtLineList().remove((Object)item);
    }

    public void clearLunchVoucherMgtLineList() {
        if (this.getLunchVoucherMgtLineList() != null) {
            this.getLunchVoucherMgtLineList().clear();
        }
    }

    public Integer getStockQuantityStatus() {
        return this.stockQuantityStatus == null ? 0 : this.stockQuantityStatus;
    }

    public void setStockQuantityStatus(Integer stockQuantityStatus) {
        this.stockQuantityStatus = stockQuantityStatus;
    }

    public Integer getStockLineQuantity() {
        return this.stockLineQuantity == null ? 0 : this.stockLineQuantity;
    }

    public void setStockLineQuantity(Integer stockLineQuantity) {
        this.stockLineQuantity = stockLineQuantity;
    }

    public String getStockLineComment() {
        return this.stockLineComment;
    }

    public void setStockLineComment(String stockLineComment) {
        this.stockLineComment = stockLineComment;
    }

    public LocalDate getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(LocalDate exportDate) {
        this.exportDate = exportDate;
    }

    public MetaFile getCsvFile() {
        return this.csvFile;
    }

    public void setCsvFile(MetaFile csvFile) {
        this.csvFile = csvFile;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LunchVoucherMgt)) {
            return false;
        }
        LunchVoucherMgt other = (LunchVoucherMgt)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("requestedLunchVouchers", (Object)this.getRequestedLunchVouchers()).add("totalLunchVouchers", (Object)this.getTotalLunchVouchers()).add("givenLunchVouchers", (Object)this.getGivenLunchVouchers()).add("lunchVoucherWageShare", (Object)this.getLunchVoucherWageShare()).add("lunchVoucherEmployersShare", (Object)this.getLunchVoucherEmployersShare()).add("stockQuantityStatus", (Object)this.getStockQuantityStatus()).add("stockLineQuantity", (Object)this.getStockLineQuantity()).add("exportDate", (Object)this.getExportDate()).omitNullValues().toString();
    }
}

