/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeBonusMgtLine;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExtraHoursLine;
import com.axelor.apps.hr.db.LunchVoucherMgtLine;
import com.axelor.apps.hr.db.OtherCostsEmployee;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_PAYROLL_PREPARATION", indexes={@Index(columnList="employment_contract"), @Index(columnList="employee"), @Index(columnList="company"), @Index(columnList="period"), @Index(columnList="fullName")})
public class PayrollPreparation
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_PAYROLL_PREPARATION_SEQ")
    @SequenceGenerator(name="HR_PAYROLL_PREPARATION_SEQ", sequenceName="HR_PAYROLL_PREPARATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employment contract")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContract employmentContract;
    @Widget(title="Employee")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Period")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Working days' number", readonly=true)
    @Digits(integer=4, fraction=1)
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Leave days' number", readonly=true)
    @Digits(integer=4, fraction=1)
    private BigDecimal leaveDuration = BigDecimal.ZERO;
    @Widget(title="Others")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<OtherCostsEmployee> otherCostsEmployeeSet;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Extra hours")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollPreparation", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ExtraHoursLine> extraHoursLineList;
    @Widget(title="Expenses")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollPreparation", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Expense> expenseList;
    @Widget(title="Employee bonuses")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollPreparation", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<EmployeeBonusMgtLine> employeeBonusMgtLineList;
    @Widget(title="Lunch vouchers")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollPreparation", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<LunchVoucherMgtLine> lunchVoucherMgtLineList;
    @Widget(title="Extra hours' number", readonly=true)
    @Digits(integer=3, fraction=2)
    private BigDecimal extraHoursNumber = BigDecimal.ZERO;
    @Widget(title="Expenses amount to pay", readonly=true)
    @Digits(integer=13, fraction=2)
    private BigDecimal expenseAmount = BigDecimal.ZERO;
    @Widget(title="Employee bonus amount", readonly=true)
    @Digits(integer=13, fraction=2)
    private BigDecimal employeeBonusAmount = BigDecimal.ZERO;
    @Widget(title="Lunch vouchers' number", readonly=true)
    @Digits(integer=4, fraction=1)
    private BigDecimal lunchVoucherNumber = BigDecimal.ZERO;
    @Widget(title="Exported", readonly=true)
    private Boolean exported = Boolean.FALSE;
    @Widget(title="Export date", readonly=true)
    private LocalDate exportDate;
    @Widget(title="Mass export list")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchList;
    @Widget(title="Export type", selection="hr.batch.payroll.preparation.export.type.select")
    private Integer exportTypeSelect = 0;
    @Widget(title="Annual gross salary")
    @Digits(integer=13, fraction=2)
    private BigDecimal annualGrossSalary = BigDecimal.ZERO;
    @Widget(title="Net salary")
    @Digits(integer=13, fraction=2)
    private BigDecimal netSalary = BigDecimal.ZERO;
    @Widget(title="Social Charges")
    @Digits(integer=13, fraction=2)
    private BigDecimal socialCharges = BigDecimal.ZERO;
    @Widget(title="Total to pay")
    @Digits(integer=13, fraction=2)
    private BigDecimal total = BigDecimal.ZERO;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EmploymentContract getEmploymentContract() {
        return this.employmentContract;
    }

    public void setEmploymentContract(EmploymentContract employmentContract) {
        this.employmentContract = employmentContract;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public BigDecimal getLeaveDuration() {
        return this.leaveDuration == null ? BigDecimal.ZERO : this.leaveDuration;
    }

    public void setLeaveDuration(BigDecimal leaveDuration) {
        this.leaveDuration = leaveDuration;
    }

    public Set<OtherCostsEmployee> getOtherCostsEmployeeSet() {
        return this.otherCostsEmployeeSet;
    }

    public void setOtherCostsEmployeeSet(Set<OtherCostsEmployee> otherCostsEmployeeSet) {
        this.otherCostsEmployeeSet = otherCostsEmployeeSet;
    }

    public void addOtherCostsEmployeeSetItem(OtherCostsEmployee item) {
        if (this.getOtherCostsEmployeeSet() == null) {
            this.setOtherCostsEmployeeSet(new HashSet<OtherCostsEmployee>());
        }
        this.getOtherCostsEmployeeSet().add(item);
    }

    public void removeOtherCostsEmployeeSetItem(OtherCostsEmployee item) {
        if (this.getOtherCostsEmployeeSet() == null) {
            return;
        }
        this.getOtherCostsEmployeeSet().remove((Object)item);
    }

    public void clearOtherCostsEmployeeSet() {
        if (this.getOtherCostsEmployeeSet() != null) {
            this.getOtherCostsEmployeeSet().clear();
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public List<ExtraHoursLine> getExtraHoursLineList() {
        return this.extraHoursLineList;
    }

    public void setExtraHoursLineList(List<ExtraHoursLine> extraHoursLineList) {
        this.extraHoursLineList = extraHoursLineList;
    }

    public void addExtraHoursLineListItem(ExtraHoursLine item) {
        if (this.getExtraHoursLineList() == null) {
            this.setExtraHoursLineList(new ArrayList<ExtraHoursLine>());
        }
        this.getExtraHoursLineList().add(item);
        item.setPayrollPreparation(this);
    }

    public void removeExtraHoursLineListItem(ExtraHoursLine item) {
        if (this.getExtraHoursLineList() == null) {
            return;
        }
        this.getExtraHoursLineList().remove((Object)item);
        item.setPayrollPreparation(null);
    }

    public void clearExtraHoursLineList() {
        if (this.getExtraHoursLineList() != null) {
            for (ExtraHoursLine item : this.getExtraHoursLineList()) {
                item.setPayrollPreparation(null);
            }
            this.getExtraHoursLineList().clear();
        }
    }

    public List<Expense> getExpenseList() {
        return this.expenseList;
    }

    public void setExpenseList(List<Expense> expenseList) {
        this.expenseList = expenseList;
    }

    public void addExpenseListItem(Expense item) {
        if (this.getExpenseList() == null) {
            this.setExpenseList(new ArrayList<Expense>());
        }
        this.getExpenseList().add(item);
        item.setPayrollPreparation(this);
    }

    public void removeExpenseListItem(Expense item) {
        if (this.getExpenseList() == null) {
            return;
        }
        this.getExpenseList().remove((Object)item);
        item.setPayrollPreparation(null);
    }

    public void clearExpenseList() {
        if (this.getExpenseList() != null) {
            for (Expense item : this.getExpenseList()) {
                item.setPayrollPreparation(null);
            }
            this.getExpenseList().clear();
        }
    }

    public List<EmployeeBonusMgtLine> getEmployeeBonusMgtLineList() {
        return this.employeeBonusMgtLineList;
    }

    public void setEmployeeBonusMgtLineList(List<EmployeeBonusMgtLine> employeeBonusMgtLineList) {
        this.employeeBonusMgtLineList = employeeBonusMgtLineList;
    }

    public void addEmployeeBonusMgtLineListItem(EmployeeBonusMgtLine item) {
        if (this.getEmployeeBonusMgtLineList() == null) {
            this.setEmployeeBonusMgtLineList(new ArrayList<EmployeeBonusMgtLine>());
        }
        this.getEmployeeBonusMgtLineList().add(item);
        item.setPayrollPreparation(this);
    }

    public void removeEmployeeBonusMgtLineListItem(EmployeeBonusMgtLine item) {
        if (this.getEmployeeBonusMgtLineList() == null) {
            return;
        }
        this.getEmployeeBonusMgtLineList().remove((Object)item);
        item.setPayrollPreparation(null);
    }

    public void clearEmployeeBonusMgtLineList() {
        if (this.getEmployeeBonusMgtLineList() != null) {
            for (EmployeeBonusMgtLine item : this.getEmployeeBonusMgtLineList()) {
                item.setPayrollPreparation(null);
            }
            this.getEmployeeBonusMgtLineList().clear();
        }
    }

    public List<LunchVoucherMgtLine> getLunchVoucherMgtLineList() {
        return this.lunchVoucherMgtLineList;
    }

    public void setLunchVoucherMgtLineList(List<LunchVoucherMgtLine> lunchVoucherMgtLineList) {
        this.lunchVoucherMgtLineList = lunchVoucherMgtLineList;
    }

    public void addLunchVoucherMgtLineListItem(LunchVoucherMgtLine item) {
        if (this.getLunchVoucherMgtLineList() == null) {
            this.setLunchVoucherMgtLineList(new ArrayList<LunchVoucherMgtLine>());
        }
        this.getLunchVoucherMgtLineList().add(item);
        item.setPayrollPreparation(this);
    }

    public void removeLunchVoucherMgtLineListItem(LunchVoucherMgtLine item) {
        if (this.getLunchVoucherMgtLineList() == null) {
            return;
        }
        this.getLunchVoucherMgtLineList().remove((Object)item);
        item.setPayrollPreparation(null);
    }

    public void clearLunchVoucherMgtLineList() {
        if (this.getLunchVoucherMgtLineList() != null) {
            for (LunchVoucherMgtLine item : this.getLunchVoucherMgtLineList()) {
                item.setPayrollPreparation(null);
            }
            this.getLunchVoucherMgtLineList().clear();
        }
    }

    public BigDecimal getExtraHoursNumber() {
        return this.extraHoursNumber == null ? BigDecimal.ZERO : this.extraHoursNumber;
    }

    public void setExtraHoursNumber(BigDecimal extraHoursNumber) {
        this.extraHoursNumber = extraHoursNumber;
    }

    public BigDecimal getExpenseAmount() {
        return this.expenseAmount == null ? BigDecimal.ZERO : this.expenseAmount;
    }

    public void setExpenseAmount(BigDecimal expenseAmount) {
        this.expenseAmount = expenseAmount;
    }

    public BigDecimal getEmployeeBonusAmount() {
        return this.employeeBonusAmount == null ? BigDecimal.ZERO : this.employeeBonusAmount;
    }

    public void setEmployeeBonusAmount(BigDecimal employeeBonusAmount) {
        this.employeeBonusAmount = employeeBonusAmount;
    }

    public BigDecimal getLunchVoucherNumber() {
        return this.lunchVoucherNumber == null ? BigDecimal.ZERO : this.lunchVoucherNumber;
    }

    public void setLunchVoucherNumber(BigDecimal lunchVoucherNumber) {
        this.lunchVoucherNumber = lunchVoucherNumber;
    }

    public Boolean getExported() {
        return this.exported == null ? Boolean.FALSE : this.exported;
    }

    public void setExported(Boolean exported) {
        this.exported = exported;
    }

    public LocalDate getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(LocalDate exportDate) {
        this.exportDate = exportDate;
    }

    public Set<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(Set<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new HashSet<Batch>());
        }
        this.getBatchList().add(item);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public Integer getExportTypeSelect() {
        return this.exportTypeSelect == null ? 0 : this.exportTypeSelect;
    }

    public void setExportTypeSelect(Integer exportTypeSelect) {
        this.exportTypeSelect = exportTypeSelect;
    }

    public BigDecimal getAnnualGrossSalary() {
        return this.annualGrossSalary == null ? BigDecimal.ZERO : this.annualGrossSalary;
    }

    public void setAnnualGrossSalary(BigDecimal annualGrossSalary) {
        this.annualGrossSalary = annualGrossSalary;
    }

    public BigDecimal getNetSalary() {
        return this.netSalary == null ? BigDecimal.ZERO : this.netSalary;
    }

    public void setNetSalary(BigDecimal netSalary) {
        this.netSalary = netSalary;
    }

    public BigDecimal getSocialCharges() {
        return this.socialCharges == null ? BigDecimal.ZERO : this.socialCharges;
    }

    public void setSocialCharges(BigDecimal socialCharges) {
        this.socialCharges = socialCharges;
    }

    public BigDecimal getTotal() {
        return this.total == null ? BigDecimal.ZERO : this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        return this.getEmployee().getName() + " " + this.getCompany().getName() + " " + this.getPeriod().getName();
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayrollPreparation)) {
            return false;
        }
        PayrollPreparation other = (PayrollPreparation)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("duration", (Object)this.getDuration()).add("leaveDuration", (Object)this.getLeaveDuration()).add("extraHoursNumber", (Object)this.getExtraHoursNumber()).add("expenseAmount", (Object)this.getExpenseAmount()).add("employeeBonusAmount", (Object)this.getEmployeeBonusAmount()).add("lunchVoucherNumber", (Object)this.getLunchVoucherNumber()).add("exported", (Object)this.getExported()).add("exportDate", (Object)this.getExportDate()).add("exportTypeSelect", (Object)this.getExportTypeSelect()).add("annualGrossSalary", (Object)this.getAnnualGrossSalary()).add("netSalary", (Object)this.getNetSalary()).omitNullValues().toString();
    }
}

