/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_TS_TIMER", indexes={@Index(columnList="user_id"), @Index(columnList="project"), @Index(columnList="product"), @Index(columnList="timesheet_line")})
public class TSTimer
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_TS_TIMER_SEQ")
    @SequenceGenerator(name="HR_TS_TIMER_SEQ", sequenceName="HR_TS_TIMER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Activity")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Start Time", readonly=true)
    private LocalDateTime startDateTime;
    @Widget(title="Timer start date time", readonly=true)
    private LocalDateTime timerStartDateT;
    @Widget(title="Duration")
    @NotNull
    private Long duration = 0L;
    @Widget(title="Timesheet Line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TimesheetLine timesheetLine;
    @Widget(title="Status Timer", readonly=true, selection="hr.timer.status.select")
    private Integer statusSelect = 2;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getTimerStartDateT() {
        return this.timerStartDateT;
    }

    public void setTimerStartDateT(LocalDateTime timerStartDateT) {
        this.timerStartDateT = timerStartDateT;
    }

    public Long getDuration() {
        return this.duration == null ? 0L : this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public TimesheetLine getTimesheetLine() {
        return this.timesheetLine;
    }

    public void setTimesheetLine(TimesheetLine timesheetLine) {
        this.timesheetLine = timesheetLine;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TSTimer)) {
            return false;
        }
        TSTimer other = (TSTimer)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("startDateTime", (Object)this.getStartDateTime()).add("timerStartDateT", (Object)this.getTimerStartDateT()).add("duration", (Object)this.getDuration()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

