/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.TimesheetReminderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_TIMESHEET_REMINDER", indexes={@Index(columnList="employee")})
public class TimesheetReminder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_TIMESHEET_REMINDER_SEQ")
    @SequenceGenerator(name="HR_TIMESHEET_REMINDER_SEQ", sequenceName="HR_TIMESHEET_REMINDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Email sent date")
    private LocalDateTime emailSentDateT;
    @Widget(title="Reminder")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="timesheetReminder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimesheetReminderLine> timesheetReminderLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public LocalDateTime getEmailSentDateT() {
        return this.emailSentDateT;
    }

    public void setEmailSentDateT(LocalDateTime emailSentDateT) {
        this.emailSentDateT = emailSentDateT;
    }

    public List<TimesheetReminderLine> getTimesheetReminderLineList() {
        return this.timesheetReminderLineList;
    }

    public void setTimesheetReminderLineList(List<TimesheetReminderLine> timesheetReminderLineList) {
        this.timesheetReminderLineList = timesheetReminderLineList;
    }

    public void addTimesheetReminderLineListItem(TimesheetReminderLine item) {
        if (this.getTimesheetReminderLineList() == null) {
            this.setTimesheetReminderLineList(new ArrayList<TimesheetReminderLine>());
        }
        this.getTimesheetReminderLineList().add(item);
        item.setTimesheetReminder(this);
    }

    public void removeTimesheetReminderLineListItem(TimesheetReminderLine item) {
        if (this.getTimesheetReminderLineList() == null) {
            return;
        }
        this.getTimesheetReminderLineList().remove((Object)item);
    }

    public void clearTimesheetReminderLineList() {
        if (this.getTimesheetReminderLineList() != null) {
            this.getTimesheetReminderLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimesheetReminder)) {
            return false;
        }
        TimesheetReminder other = (TimesheetReminder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("emailSentDateT", (Object)this.getEmailSentDateT()).omitNullValues().toString();
    }
}

