/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_TIMESHEET_REPORT")
public class TimesheetReport
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_TIMESHEET_REPORT_SEQ")
    @SequenceGenerator(name="HR_TIMESHEET_REPORT_SEQ", sequenceName="HR_TIMESHEET_REPORT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="From Date")
    private LocalDate fromDate;
    @Widget(title="To Date")
    private LocalDate toDate;
    @Widget(title="Users")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> userSet;
    @Widget(title="Type", selection="hr.employee.timesheet.report.type.select")
    private Integer typeSelect = 0;
    @Widget(title="User to be reminded")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> reminderUserSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Set<User> getUserSet() {
        return this.userSet;
    }

    public void setUserSet(Set<User> userSet) {
        this.userSet = userSet;
    }

    public void addUserSetItem(User item) {
        if (this.getUserSet() == null) {
            this.setUserSet(new HashSet<User>());
        }
        this.getUserSet().add(item);
    }

    public void removeUserSetItem(User item) {
        if (this.getUserSet() == null) {
            return;
        }
        this.getUserSet().remove((Object)item);
    }

    public void clearUserSet() {
        if (this.getUserSet() != null) {
            this.getUserSet().clear();
        }
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Set<User> getReminderUserSet() {
        return this.reminderUserSet;
    }

    public void setReminderUserSet(Set<User> reminderUserSet) {
        this.reminderUserSet = reminderUserSet;
    }

    public void addReminderUserSetItem(User item) {
        if (this.getReminderUserSet() == null) {
            this.setReminderUserSet(new HashSet<User>());
        }
        this.getReminderUserSet().add(item);
    }

    public void removeReminderUserSetItem(User item) {
        if (this.getReminderUserSet() == null) {
            return;
        }
        this.getReminderUserSet().remove((Object)item);
    }

    public void clearReminderUserSet() {
        if (this.getReminderUserSet() != null) {
            this.getReminderUserSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimesheetReport)) {
            return false;
        }
        TimesheetReport other = (TimesheetReport)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

