/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.project.ProjectPlanningTimeService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.TeamTaskProjectRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.google.inject.Inject;

public class TeamTaskHRRepository
extends TeamTaskProjectRepository {
    @Inject
    private ProjectPlanningTimeService projectPlanningTimeService;

    public TeamTask save(TeamTask teamTask) {
        if (!((AppHumanResourceService)Beans.get(AppHumanResourceService.class)).isApp("employee")) {
            return super.save(teamTask);
        }
        teamTask.setTotalPlannedHrs(this.projectPlanningTimeService.getTaskPlannedHrs(teamTask));
        Project project = teamTask.getProject();
        project.setTotalPlannedHrs(this.projectPlanningTimeService.getProjectPlannedHrs(project));
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            parentProject.setTotalPlannedHrs(this.projectPlanningTimeService.getProjectPlannedHrs(parentProject));
        }
        return teamTask;
    }

    public void remove(TeamTask teamTask) {
        Project project = teamTask.getProject();
        super.remove((Model)((Object)teamTask));
        project.setTotalPlannedHrs(this.projectPlanningTimeService.getProjectPlannedHrs(project));
    }

    public TeamTask copy(TeamTask entity, boolean deep) {
        entity.setTotalPlannedHrs(null);
        entity.setTotalRealHrs(null);
        entity.setProjectPlanningTimeList(null);
        return super.copy(entity, deep);
    }
}

