/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeAdvance;
import com.axelor.apps.hr.db.EmployeeAdvanceUsage;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.EmployeeAdvanceRepository;
import com.axelor.apps.hr.db.repo.EmployeeAdvanceUsageRepository;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public class EmployeeAdvanceService {
    @Inject
    private EmployeeAdvanceRepository employeeAdvanceRepository;
    @Inject
    private EmployeeAdvanceUsageRepository employeeAdvanceUsageRepository;

    @Transactional
    public void fillExpenseWithAdvances(Expense expense) {
        Employee employee = (Employee)((Object)((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).find(expense.getUser().getEmployee().getId()));
        List advanceList = this.employeeAdvanceRepository.all().filter("self.employee.id = ?1 AND self.remainingAmount > 0 AND self.date < ?2 AND self.statusSelect = ?3 AND self.typeSelect = ?4", new Object[]{employee.getId(), expense.getPeriod().getToDate(), 2, 2}).fetch();
        if (advanceList != null && !advanceList.isEmpty()) {
            BigDecimal currentAmountToRefund = expense.getInTaxTotal().subtract(expense.getPersonalExpenseAmount()).subtract(expense.getWithdrawnCash());
            for (EmployeeAdvance advance : advanceList) {
                if (currentAmountToRefund.signum() == 0) break;
                currentAmountToRefund = this.withdrawFromAdvance(advance, expense, currentAmountToRefund);
                this.employeeAdvanceRepository.save((Model)((Object)advance));
            }
            expense.setAdvanceAmount(expense.getInTaxTotal().subtract(currentAmountToRefund).subtract(expense.getPersonalExpenseAmount()).subtract(expense.getWithdrawnCash()));
        }
    }

    public BigDecimal withdrawFromAdvance(EmployeeAdvance employeeAdvance, Expense expense, BigDecimal maxAmount) {
        if (maxAmount.compareTo(employeeAdvance.getRemainingAmount()) > 0) {
            maxAmount = maxAmount.subtract(employeeAdvance.getRemainingAmount());
            this.createEmployeeAdvanceUsage(employeeAdvance, expense, employeeAdvance.getRemainingAmount());
            employeeAdvance.setRemainingAmount(BigDecimal.ZERO);
        } else {
            this.createEmployeeAdvanceUsage(employeeAdvance, expense, maxAmount);
            employeeAdvance.setRemainingAmount(employeeAdvance.getRemainingAmount().subtract(maxAmount));
            maxAmount = BigDecimal.ZERO;
        }
        return maxAmount;
    }

    @Transactional
    public void createEmployeeAdvanceUsage(EmployeeAdvance employeeAdvance, Expense expense, BigDecimal amount) {
        EmployeeAdvanceUsage usage = new EmployeeAdvanceUsage();
        usage.setEmployeeAdvance(employeeAdvance);
        usage.setExpense(expense);
        usage.setUsedAmount(amount);
        this.employeeAdvanceUsageRepository.save((Model)((Object)usage));
    }
}

