/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service;

import com.axelor.apps.base.db.Period;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeBonusMgt;
import com.axelor.apps.hr.db.EmployeeBonusMgtLine;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.repo.EmployeeBonusMgtLineRepository;
import com.axelor.apps.hr.db.repo.EmployeeBonusMgtRepository;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.service.employee.EmployeeServiceImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.tool.template.TemplateMaker;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class EmployeeBonusService {
    @Inject
    EmployeeBonusMgtRepository employeeBonusMgtRepo;
    @Inject
    EmployeeBonusMgtLineRepository employeeBonusMgtLineRepo;
    @Inject
    EmployeeServiceImpl employeeService;
    private static final char TEMPLATE_DELIMITER = '$';

    @Transactional(rollbackOn={Exception.class})
    public void compute(EmployeeBonusMgt bonus) throws AxelorException {
        HashMap<Employee, EmployeeBonusMgtLine> employeeStatus = new HashMap<Employee, EmployeeBonusMgtLine>();
        for (EmployeeBonusMgtLine line : bonus.getEmployeeBonusMgtLineList()) {
            employeeStatus.put(line.getEmployee(), line);
        }
        List allEmployee = ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.mainEmploymentContract.payCompany = ?1", new Object[]{bonus.getCompany()}).fetch();
        TemplateMaker maker = new TemplateMaker(Locale.FRENCH, '$', '$');
        CompilerConfiguration conf = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"java.lang.Math"});
        conf.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding, conf);
        Integer employeeBonusStatus = EmployeeBonusMgtRepository.STATUS_CALCULATED;
        for (Employee employee : allEmployee) {
            if (employeeStatus.get((Object)employee) != null) {
                if (((EmployeeBonusMgtLine)((Object)employeeStatus.get((Object)employee))).getStatusSelect().equals(EmployeeBonusMgtLineRepository.STATUS_CALCULATED)) continue;
                bonus.removeEmployeeBonusMgtLineListItem((EmployeeBonusMgtLine)((Object)employeeStatus.get((Object)employee)));
            }
            maker.setContext((Model)((Object)employee), "Employee");
            EmployeeBonusMgtLine line = new EmployeeBonusMgtLine();
            line.setEmployeeBonusMgt(bonus);
            line.setEmployee(employee);
            maker.addInContext("EmployeeBonusMgtLine", (Object)line);
            String formula = bonus.getEmployeeBonusType().getApplicationCondition();
            Integer lineStatus = EmployeeBonusMgtLineRepository.STATUS_CALCULATED;
            try {
                formula = this.replaceExpressionInFormula(formula, bonus.getCompany().getHrConfig(), employee, bonus.getPayPeriod());
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
                formula = "true";
                lineStatus = EmployeeBonusMgtLineRepository.STATUS_ANOMALY;
            }
            maker.setTemplate(formula);
            String eval = maker.make();
            if (!shell.evaluate(eval).toString().equals("true")) continue;
            try {
                formula = this.replaceExpressionInFormula(bonus.getEmployeeBonusType().getFormula(), bonus.getCompany().getHrConfig(), employee, bonus.getPayPeriod());
            }
            catch (Exception e) {
                lineStatus = EmployeeBonusMgtLineRepository.STATUS_ANOMALY;
            }
            line.setStatusSelect(lineStatus);
            if (lineStatus.equals(EmployeeBonusMgtLineRepository.STATUS_ANOMALY)) {
                employeeBonusStatus = EmployeeBonusMgtRepository.STATUS_ANOMALY;
                this.employeeBonusMgtLineRepo.save((Model)((Object)line));
                continue;
            }
            line.setSeniorityDate(employee.getSeniorityDate());
            line.setCoef(employee.getBonusCoef());
            line.setWeeklyPlanning(employee.getWeeklyPlanning());
            maker.setTemplate(formula);
            eval = maker.make();
            line.setAmount(new BigDecimal(shell.evaluate(eval).toString()));
            this.employeeBonusMgtLineRepo.save((Model)((Object)line));
        }
        bonus.setStatusSelect(employeeBonusStatus);
        this.employeeBonusMgtRepo.save((Model)((Object)bonus));
    }

    public String replaceExpressionInFormula(String formula, HRConfig hrConfig, Employee employee, Period period) throws AxelorException {
        if (!Strings.isNullOrEmpty((String)hrConfig.getAgeVariableName())) {
            formula = formula.replace(hrConfig.getAgeVariableName(), String.valueOf(this.employeeService.getAge(employee, period.getFromDate())));
        }
        if (!Strings.isNullOrEmpty((String)hrConfig.getSeniorityVariableName())) {
            formula = formula.replace(hrConfig.getSeniorityVariableName(), String.valueOf(this.employeeService.getLengthOfService(employee, period.getFromDate())));
        }
        if (!Strings.isNullOrEmpty((String)hrConfig.getWorkingDaysVariableName())) {
            formula = formula.replace(hrConfig.getWorkingDaysVariableName(), String.valueOf(this.employeeService.getDaysWorkedInPeriod(employee, period.getFromDate(), period.getToDate())));
        }
        if (!Strings.isNullOrEmpty((String)hrConfig.getTotalWorkingDaysVariableName())) {
            formula = formula.replace(hrConfig.getTotalWorkingDaysVariableName(), String.valueOf(this.employeeService.getDaysWorksInPeriod(employee, period.getFromDate(), period.getToDate())));
        }
        if (formula.matches("(\\$\\w+\\$).+")) {
            throw new AxelorException(1, I18n.get((String)"Please configure Formula Variables for human resource for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return formula;
    }
}

