/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service;

import com.axelor.app.AppSettings;
import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Department;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.repo.EmploymentContractRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class EmploymentContractService {
    @Inject
    private EmploymentContractRepository employmentContractRepo;

    @Transactional(rollbackOn={Exception.class})
    public int addAmendment(EmploymentContract employmentContract) throws AxelorException {
        String name = employmentContract.getFullName() + "_" + employmentContract.getEmploymentContractVersion();
        ReportFactory.createReport((String)"EmploymentContract.rptdesign", (String)(name + "-${date}")).addParam("ContractId", (Object)employmentContract.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)employmentContract)).generate().getFileLink();
        int version = employmentContract.getEmploymentContractVersion() + 1;
        employmentContract.setEmploymentContractVersion(version);
        this.employmentContractRepo.save((Model)((Object)employmentContract));
        return version;
    }

    public void exportEmploymentContract(EmploymentContract employmentContract) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        this.employmentContractExportSilae(employmentContract, list);
        String fileName = this.employmentContractExportName() + ".csv";
        String filePath = AppSettings.get().get("file.upload.dir");
        new File(filePath).mkdirs();
        String[] headers = this.employmentContractExportHeaders();
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (String[])headers, list);
        Path path = Paths.get(filePath + System.getProperty("file.separator") + fileName, new String[0]);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, fileName, (Model)((Object)employmentContract));
        }
    }

    public void employmentContractExportSilae(EmploymentContract employmentContract, List<String[]> list) {
        String[] item = new String[21];
        item[0] = employmentContract.getId().toString();
        item[1] = employmentContract.getStartDate() == null ? "" : employmentContract.getStartDate().toString();
        item[2] = employmentContract.getEndDate() == null ? "" : employmentContract.getEndDate().toString();
        Employee employee = employmentContract.getEmployee();
        item[4] = employee.getMaritalName();
        Partner contactPartner = employee.getContactPartner();
        if (contactPartner != null) {
            item[3] = contactPartner.getName();
            item[5] = contactPartner.getFirstName();
            Address mainAddress = contactPartner.getMainAddress();
            if (mainAddress != null) {
                item[6] = mainAddress.getAddressL4();
                item[7] = mainAddress.getAddressL2();
                item[8] = mainAddress.getZip();
                item[9] = mainAddress.getCity().getName();
            }
            item[10] = contactPartner.getMobilePhone();
            item[11] = contactPartner.getFixedPhone();
            item[12] = contactPartner.getEmailAddress() == null ? "" : contactPartner.getEmailAddress().getAddress();
        }
        item[13] = employee.getBirthDate() == null ? "" : employee.getBirthDate().toString();
        Department birthDepartment = employee.getDepartmentOfBirth();
        if (birthDepartment != null) {
            item[14] = birthDepartment.getName();
            item[16] = !birthDepartment.getCode().equals("99") ? "FR - FRANCE" : "Oui";
        }
        item[15] = employee.getCityOfBirth() == null ? "" : employee.getCityOfBirth().getName();
        item[17] = employee.getSocialSecurityNumber();
        item[18] = employmentContract.getPayCompany().getName();
        item[19] = employmentContract.getContractType() == null ? "" : employmentContract.getContractType().getId().toString();
        item[20] = employee.getMaidenName();
        list.add(item);
    }

    public String employmentContractExportName() {
        return I18n.get((String)"Employment contract") + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime().toString();
    }

    public String[] employmentContractExportHeaders() {
        String[] headers = new String[]{I18n.get((String)"MATRICULE"), I18n.get((String)"DATE D'ENTREE"), I18n.get((String)"DATE DE SORTIE"), I18n.get((String)"NOM"), I18n.get((String)"NOM MARITAL"), I18n.get((String)"PRENOM"), I18n.get((String)"VOIE"), I18n.get((String)"COMPLEMENT"), I18n.get((String)"CP"), I18n.get((String)"VILLE"), I18n.get((String)"TEL"), I18n.get((String)"TEL 2"), I18n.get((String)"E-MAIL"), I18n.get((String)"DATE NAISS"), I18n.get((String)"DEPT NAISS"), I18n.get((String)"LIEU"), I18n.get((String)"ETRANGER"), I18n.get((String)"NUMERO INSEE"), I18n.get((String)"ETAB"), I18n.get((String)"CDD"), I18n.get((String)"NOM DE JEUNE FILLE")};
        return headers;
    }
}

