/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.YearServiceImpl;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.KilometricAllowanceRate;
import com.axelor.apps.hr.db.KilometricAllowanceRule;
import com.axelor.apps.hr.db.KilometricLog;
import com.axelor.apps.hr.db.repo.KilometricAllowanceRateRepository;
import com.axelor.apps.hr.db.repo.KilometricLogRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import wslite.json.JSONException;
import wslite.json.JSONObject;

public class KilometricService {
    private AppBaseService appBaseService;
    private KilometricLogRepository kilometricLogRepo;
    private MapService mapService;

    @Inject
    public KilometricService(AppBaseService appBaseService, KilometricLogRepository kilometricLogRepo, MapService mapService) {
        this.appBaseService = appBaseService;
        this.kilometricLogRepo = kilometricLogRepo;
        this.mapService = mapService;
    }

    public KilometricLog getKilometricLog(Employee employee, LocalDate refDate) {
        for (KilometricLog log : employee.getKilometricLogList()) {
            if (!log.getYear().getFromDate().isBefore(refDate) || !log.getYear().getToDate().isAfter(refDate)) continue;
            return log;
        }
        return null;
    }

    public KilometricLog getCurrentKilometricLog(Employee employee) {
        return this.getKilometricLog(employee, this.appBaseService.getTodayDate());
    }

    public KilometricLog createKilometricLog(Employee employee, BigDecimal distance, Year year) {
        KilometricLog log = new KilometricLog();
        log.setEmployee(employee);
        log.setDistanceTravelled(distance);
        log.setYear(year);
        return log;
    }

    public KilometricLog getOrCreateKilometricLog(Employee employee, LocalDate date) throws AxelorException {
        KilometricLog log = this.getKilometricLog(employee, date);
        if (log != null) {
            return log;
        }
        if (employee.getMainEmploymentContract() == null) {
            throw new AxelorException(4, I18n.get((String)"Please, add a contract of employment for employee : %s"), new Object[]{employee.getName()});
        }
        Year year = ((YearServiceImpl)Beans.get(YearServiceImpl.class)).getYear(date, employee.getMainEmploymentContract().getPayCompany());
        if (year == null) {
            throw new AxelorException(4, I18n.get((String)"There is no year for society %s which includes date %s"), new Object[]{employee.getMainEmploymentContract().getPayCompany(), date});
        }
        return this.createKilometricLog(employee, new BigDecimal("0.00"), year);
    }

    public BigDecimal computeKilometricExpense(ExpenseLine expenseLine, Employee employee) throws AxelorException {
        KilometricAllowanceRate allowance;
        BigDecimal distance = expenseLine.getDistance();
        EmploymentContract mainEmploymentContract = employee.getMainEmploymentContract();
        if (mainEmploymentContract == null || mainEmploymentContract.getPayCompany() == null) {
            throw new AxelorException(4, I18n.get((String)"Please, add a contract of employment for employee : %s"), new Object[]{employee.getName()});
        }
        Company company = mainEmploymentContract.getPayCompany();
        KilometricLog log = this.getKilometricLog(employee, expenseLine.getExpenseDate());
        BigDecimal previousDistance = log == null ? BigDecimal.ZERO : log.getDistanceTravelled();
        KilometricAllowanceRate kilometricAllowanceRate = allowance = expenseLine.getKilometricAllowParam() != null ? (KilometricAllowanceRate)((Object)((KilometricAllowanceRateRepository)((Object)Beans.get(KilometricAllowanceRateRepository.class))).all().filter("self.kilometricAllowParam.id = :_kilometricAllowParamId and self.hrConfig.id = :_hrConfigId").bind("_kilometricAllowParamId", (Object)expenseLine.getKilometricAllowParam().getId()).bind("_hrConfigId", (Object)((HRConfigService)Beans.get(HRConfigService.class)).getHRConfig(company).getId()).fetchOne()) : null;
        if (allowance == null) {
            throw new AxelorException(4, I18n.get((String)"The kilometric allowance rate corresponding to the kilometric allow param %s and the company %s is missing"), new Object[]{expenseLine.getKilometricAllowParam() != null ? expenseLine.getKilometricAllowParam().getName() : "", company.getName()});
        }
        ArrayList<KilometricAllowanceRule> ruleList = new ArrayList<KilometricAllowanceRule>();
        List<KilometricAllowanceRule> allowanceRuleList = allowance.getKilometricAllowanceRuleList();
        if (ObjectUtils.notEmpty(allowanceRuleList)) {
            for (KilometricAllowanceRule rule : allowanceRuleList) {
                if (rule.getMinimumCondition().compareTo(previousDistance.add(distance)) > 0 || rule.getMaximumCondition().compareTo(previousDistance) < 0) continue;
                ruleList.add(rule);
            }
        }
        if (ruleList.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"There is no matching condition for the allowance %s"), new Object[]{allowance.getKilometricAllowParam().getName()});
        }
        BigDecimal price = BigDecimal.ZERO;
        if (ruleList.size() == 1) {
            price = distance.multiply(((KilometricAllowanceRule)((Object)ruleList.get(0))).getRate());
        } else {
            Collections.sort(ruleList, (object1, object2) -> object1.getMinimumCondition().compareTo(object2.getMinimumCondition()));
            for (KilometricAllowanceRule rule : ruleList) {
                BigDecimal min = rule.getMinimumCondition().max(previousDistance);
                BigDecimal max = rule.getMaximumCondition().min(previousDistance.add(distance));
                price = price.add(max.subtract(min).multiply(rule.getRate()));
            }
        }
        return price.setScale(2, RoundingMode.HALF_UP);
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateKilometricLog(ExpenseLine expenseLine, Employee employee) throws AxelorException {
        KilometricLog log = this.getOrCreateKilometricLog(employee, expenseLine.getExpenseDate());
        log.setDistanceTravelled(log.getDistanceTravelled().add(expenseLine.getDistance()));
        if (log.getExpenseLineList() == null || !log.getExpenseLineList().contains((Object)expenseLine)) {
            log.addExpenseLineListItem(expenseLine);
        }
        this.kilometricLogRepo.save((Model)((Object)log));
    }

    public BigDecimal computeDistance(ExpenseLine expenseLine) throws AxelorException {
        return this.computeDistance(expenseLine.getFromCity(), expenseLine.getToCity());
    }

    protected BigDecimal computeDistance(String fromCity, String toCity) throws AxelorException {
        BigDecimal distance = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)fromCity) || StringUtils.isEmpty((String)toCity) || fromCity.equalsIgnoreCase(toCity)) {
            return distance;
        }
        AppBase appBase = this.appBaseService.getAppBase();
        try {
            switch (appBase.getMapApiSelect()) {
                case 1: {
                    distance = this.getDistanceUsingGoogle(fromCity, toCity);
                    break;
                }
                case 2: {
                    distance = this.getDistanceUsingOSM(fromCity, toCity);
                }
            }
            return distance;
        }
        catch (IOException | URISyntaxException | JSONException e) {
            throw new AxelorException(e, 4);
        }
    }

    protected BigDecimal getDistanceUsingGoogle(String fromCity, String toCity) throws JSONException, AxelorException, URISyntaxException, IOException {
        JSONObject response;
        User user = AuthUtils.getUser();
        JSONObject json = this.getGoogleMapsDistanceMatrixResponse(fromCity, toCity, user.getLanguage());
        String status = json.getString("status");
        if (status.equals("OK") && (status = (response = json.getJSONArray("rows").getJSONObject(0).getJSONArray("elements").getJSONObject(0)).getString("status")).equals("OK")) {
            return BigDecimal.valueOf(response.getJSONObject("distance").getDouble("value") / 1000.0);
        }
        String msg = json.has("error_message") ? String.format("%s / %s", status, json.getString("error_message")) : status;
        throw new AxelorException(4, "Google Maps error: %s", new Object[]{msg});
    }

    protected BigDecimal getDistanceUsingOSM(String fromCity, String toCity) throws JSONException, AxelorException, URISyntaxException, IOException {
        AppBase appBase = this.appBaseService.getAppBase();
        BigDecimal distance = BigDecimal.ZERO;
        if (appBase.getOsmRoutingServiceApiSelect() == 1) {
            distance = this.getDistanceUsingYOURSApi(fromCity, toCity);
        } else if (appBase.getOsmRoutingServiceApiSelect() == 2) {
            distance = this.getDistanceUsingOSRMApi(fromCity, toCity);
        }
        return distance;
    }

    protected BigDecimal getDistanceUsingYOURSApi(String fromCity, String toCity) throws AxelorException, JSONException, URISyntaxException, IOException {
        BigDecimal distance = BigDecimal.ZERO;
        JSONObject json = this.getYOURSApiResponse(fromCity, toCity);
        distance = BigDecimal.valueOf(json.getJSONObject("properties").getDouble("distance"));
        if (distance.compareTo(BigDecimal.ZERO) == 0) {
            throw new AxelorException(4, "Open Street Maps error: %s", new Object[]{"No Route Found"});
        }
        return distance;
    }

    protected BigDecimal getDistanceUsingOSRMApi(String fromCity, String toCity) throws AxelorException, JSONException, URISyntaxException, IOException {
        JSONObject json = this.getOSRMApiResponse(fromCity, toCity);
        String status = json.getString("code");
        if (status.equals("Ok")) {
            return BigDecimal.valueOf(json.getJSONArray("routes").getJSONObject(0).getDouble("distance") / 1000.0);
        }
        String msg = json.has("message") ? String.format("%s", json.getString("message")) : status;
        throw new AxelorException(4, "Open Street Maps error: %s", new Object[]{msg});
    }

    protected JSONObject getGoogleMapsDistanceMatrixResponse(String origins, String destinations, String language) throws URISyntaxException, IOException, JSONException, AxelorException {
        URIBuilder ub = new URIBuilder("https://maps.googleapis.com/maps/api/distancematrix/json");
        ub.addParameter("origins", origins);
        ub.addParameter("destinations", destinations);
        ub.addParameter("language", language);
        ub.addParameter("key", this.mapService.getGoogleMapsApiKey());
        return this.getApiResponse(ub.toString(), "Google Maps error: %s");
    }

    protected JSONObject getOSRMApiResponse(String origins, String destinations) throws AxelorException, JSONException, URISyntaxException, IOException {
        Map<String, Object> originMap = this.getLocationMap(origins);
        Map<String, Object> destinationMap = this.getLocationMap(destinations);
        String originCoordinates = originMap.get("longitude") + "," + originMap.get("latitude");
        String destinationCoordinates = destinationMap.get("longitude") + "," + destinationMap.get("latitude");
        String uri = String.format("https://router.project-osrm.org/route/v1/driving/%s;%s", originCoordinates, destinationCoordinates);
        return this.getApiResponse(uri, "Open Street Maps error: %s");
    }

    protected JSONObject getYOURSApiResponse(String origins, String destinations) throws AxelorException, JSONException, URISyntaxException, IOException {
        Map<String, Object> originMap = this.getLocationMap(origins);
        Map<String, Object> destinationMap = this.getLocationMap(destinations);
        String flat = originMap.get("latitude").toString();
        String flon = originMap.get("longitude").toString();
        String tlat = destinationMap.get("latitude").toString();
        String tlon = destinationMap.get("longitude").toString();
        URIBuilder ub = new URIBuilder("http://www.yournavigation.org/api/1.0/gosmore.php");
        ub.addParameter("format", "geojson");
        ub.addParameter("flat", flat);
        ub.addParameter("flon", flon);
        ub.addParameter("tlat", tlat);
        ub.addParameter("tlon", tlon);
        ub.addParameter("v", "motorcar");
        ub.addParameter("fast", "0");
        return this.getApiResponse(ub.toString(), "Open Street Maps error: %s");
    }

    protected Map<String, Object> getLocationMap(String location) throws AxelorException {
        Map locationMap;
        try {
            locationMap = this.mapService.getMap(location);
        }
        catch (Exception e) {
            throw new AxelorException(4, "Open Street Maps error: %s", new Object[]{e.getMessage()});
        }
        if (locationMap == null) {
            throw new AxelorException(4, "Open Street Maps error: %s", new Object[]{"No such place exists"});
        }
        return locationMap;
    }

    protected JSONObject getApiResponse(String urlString, String exceptionMessage) throws IOException, JSONException, AxelorException {
        JSONObject json;
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int responseCode = connection.getResponseCode();
        this.checkResponseStatus(responseCode, exceptionMessage);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine + "\n");
            }
        }
        String response = sb.toString();
        try {
            json = new JSONObject(response);
        }
        catch (Exception e) {
            throw new AxelorException(4, exceptionMessage, new Object[]{response});
        }
        return json;
    }

    protected void checkResponseStatus(int responseCode, String exceptionMessage) throws AxelorException {
        if (responseCode == 200) {
            return;
        }
        if (responseCode == 429) {
            throw new AxelorException(4, exceptionMessage, new Object[]{"Too many requests"});
        }
        throw new AxelorException(4, exceptionMessage, new Object[]{"Server returned status code " + responseCode});
    }
}

