/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.bankorder;

import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeServiceImpl;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.ExpenseHRRepository;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BankOrderMergeHRServiceImpl
extends BankOrderMergeServiceImpl {
    protected ExpenseHRRepository expenseHRRepository;

    @Inject
    public BankOrderMergeHRServiceImpl(BankOrderRepository bankOrderRepo, InvoicePaymentRepository invoicePaymentRepo, BankOrderService bankOrderService, InvoiceRepository invoiceRepository, PaymentScheduleLineRepository paymentScheduleLineRepository, ExpenseHRRepository expenseHRRepository) {
        super(bankOrderRepo, invoicePaymentRepo, bankOrderService, invoiceRepository, paymentScheduleLineRepository);
        this.expenseHRRepository = expenseHRRepository;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public BankOrder mergeBankOrders(Collection<BankOrder> bankOrders) throws AxelorException {
        if (!((AppService)Beans.get(AppService.class)).isApp("employee")) {
            return super.mergeBankOrders(bankOrders);
        }
        List expenseList = this.expenseHRRepository.all().filter("self.bankOrder.id IN (?)", new Object[]{bankOrders.stream().map(BankOrder::getId).collect(Collectors.toList())}).fetch();
        for (Expense expense : expenseList) {
            expense.setBankOrder(null);
            this.expenseHRRepository.save(expense);
        }
        BankOrder bankOrder = super.mergeBankOrders(bankOrders);
        for (Expense expense : expenseList) {
            expense.setBankOrder(bankOrder);
            this.expenseHRRepository.save(expense);
        }
        return bankOrder;
    }
}

