/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.batch.BatchCreditTransferExpensePayment;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCreditTransferExpensePaymentHR
extends BatchCreditTransferExpensePayment {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final AppAccountService appAccountService;
    protected final ExpenseRepository expenseRepo;
    protected final ExpenseService expenseService;
    protected final BankOrderMergeService bankOrderMergeService;

    @Inject
    public BatchCreditTransferExpensePaymentHR(AppAccountService appAccountService, ExpenseRepository expenseRepo, ExpenseService expenseService, BankOrderMergeService bankOrderMergeService) {
        this.appAccountService = appAccountService;
        this.expenseRepo = expenseRepo;
        this.expenseService = expenseService;
        this.bankOrderMergeService = bankOrderMergeService;
    }

    protected void process() {
        List<Expense> doneList = this.processExpenses();
        try {
            this.mergeBankOrders(doneList);
        }
        catch (Exception ex) {
            TraceBackService.trace((Throwable)ex);
            ex.printStackTrace();
            this.log.error("Credit transfer batch for expense payments: mergeBankOrders");
        }
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Report for credit transfer batch:")).append(" ");
        sb.append(String.format(I18n.get((String)"%d expense treated successfully,", (String)"%d expenses treated successfully,", (int)this.batch.getDone()) + " ", this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }

    protected List<Expense> processExpenses() {
        List expenseList;
        ArrayList<Expense> doneList = new ArrayList<Expense>();
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        boolean manageMultiBanks = this.appAccountService.getAppBase().getManageMultiBanks();
        String filter = "self.ventilated = true AND self.paymentStatusSelect = :paymentStatusSelect AND self.company = :company AND self.user.partner.outPaymentMode = :paymentMode AND self.id NOT IN (:anomalyList)";
        if (manageMultiBanks) {
            filter = filter + " AND self.bankDetails IN (:bankDetailsSet)";
        }
        Query query = this.expenseRepo.all().filter(filter).bind("paymentStatusSelect", (Object)0).bind("company", (Object)accountingBatch.getCompany()).bind("paymentMode", (Object)accountingBatch.getPaymentMode()).bind("anomalyList", (Object)anomalyList);
        if (manageMultiBanks) {
            HashSet bankDetailsSet = Sets.newHashSet((Object[])new BankDetails[]{accountingBatch.getBankDetails()});
            if (accountingBatch.getIncludeOtherBankAccounts().booleanValue()) {
                bankDetailsSet.addAll(accountingBatch.getCompany().getBankDetailsSet());
            }
            query.bind("bankDetailsSet", (Object)bankDetailsSet);
        }
        while (!(expenseList = query.fetch(10)).isEmpty()) {
            for (Expense expense : expenseList) {
                try {
                    this.addPayment(expense, accountingBatch.getBankDetails());
                    doneList.add(expense);
                    this.incrementDone();
                }
                catch (Exception ex) {
                    this.incrementAnomaly();
                    anomalyList.add(expense.getId());
                    query.bind("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)ex, (String)"creditTransfer", (long)this.batch.getId());
                    ex.printStackTrace();
                    this.log.error(String.format("Credit transfer batch for expense payment: anomaly for expense %s", expense.getExpenseSeq()));
                    break;
                }
            }
            JPA.clear();
        }
        return doneList;
    }

    @Transactional(rollbackOn={Exception.class})
    protected void addPayment(Expense expense, BankDetails bankDetails) throws AxelorException {
        this.log.debug(String.format("Credit transfer batch for expense payment: adding payment for expense %s", expense.getExpenseSeq()));
        this.expenseService.addPayment(expense, bankDetails);
    }

    @Transactional(rollbackOn={Exception.class})
    protected void mergeBankOrders(List<Expense> doneList) throws AxelorException {
        ArrayList<Expense> expenseList = new ArrayList<Expense>();
        ArrayList<BankOrder> bankOrderList = new ArrayList<BankOrder>();
        for (Expense expense : doneList) {
            BankOrder bankOrder = expense.getBankOrder();
            if (bankOrder == null) continue;
            expenseList.add(expense);
            bankOrderList.add(bankOrder);
        }
        if (bankOrderList.size() > 1) {
            BankOrder mergedBankOrder = this.bankOrderMergeService.mergeBankOrders(bankOrderList);
            for (Expense expense : expenseList) {
                expense.setBankOrder(mergedBankOrder);
            }
        }
    }
}

