/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveManagement;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.repo.LeaveLineRepository;
import com.axelor.apps.hr.db.repo.LeaveManagementRepository;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.leave.management.LeaveManagementService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Digits;

public class BatchLeaveManagement
extends BatchStrategy {
    int total;
    int noValueAnomaly;
    int confAnomaly;
    protected LeaveLineRepository leaveLineRepository;
    protected LeaveManagementRepository leaveManagementRepository;
    @Inject
    private Provider<LeaveService> leaveServiceProvider;

    @Inject
    public BatchLeaveManagement(LeaveManagementService leaveManagementService, LeaveLineRepository leaveLineRepository, LeaveManagementRepository leaveManagementRepository) {
        super(leaveManagementService);
        this.leaveLineRepository = leaveLineRepository;
        this.leaveManagementRepository = leaveManagementRepository;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        if (this.batch.getHrBatch().getDayNumber() == null || this.batch.getHrBatch().getDayNumber().signum() == 0 || this.batch.getHrBatch().getLeaveReason() == null) {
            TraceBackService.trace((AxelorException)new AxelorException(4, I18n.get((String)"Leave reason and day number have to be defined")), (String)"leaveManagement", (long)this.batch.getId());
        }
        this.total = 0;
        this.noValueAnomaly = 0;
        this.confAnomaly = 0;
        this.checkPoint();
    }

    protected void process() {
        List<Employee> employeeList = this.getEmployees(this.batch.getHrBatch());
        this.generateLeaveManagementLines(employeeList);
    }

    public List<Employee> getEmployees(HrBatch hrBatch) {
        ArrayList query = Lists.newArrayList();
        if (hrBatch.getEmployeeSet() != null && !hrBatch.getEmployeeSet().isEmpty()) {
            String employeeIds = Joiner.on((char)',').join(Iterables.transform(hrBatch.getEmployeeSet(), obj -> obj.getId().toString()));
            query.add("self.id IN (" + employeeIds + ")");
        }
        if (hrBatch.getEmployeeSet() != null && !hrBatch.getPlanningSet().isEmpty()) {
            String planningIds = Joiner.on((char)',').join(Iterables.transform(hrBatch.getPlanningSet(), obj -> obj.getId().toString()));
            query.add("self.weeklyPlanning.id IN (" + planningIds + ")");
        }
        String liaison = query.isEmpty() ? "" : " AND";
        List employeeList = hrBatch.getCompany() != null ? JPA.all(Employee.class).filter(Joiner.on((String)" AND ").join((Iterable)query) + liaison + " self.mainEmploymentContract.payCompany = :company").bind("company", (Object)hrBatch.getCompany()).fetch() : JPA.all(Employee.class).filter(Joiner.on((String)" AND ").join((Iterable)query)).fetch();
        return employeeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateLeaveManagementLines(List<Employee> employeeList) {
        for (Employee employee : employeeList) {
            try {
                this.createLeaveManagement((Employee)((Object)this.employeeRepository.find(employee.getId())));
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e, (String)"leaveManagement", (long)this.batch.getId());
                this.incrementAnomaly();
                if (e.getCategory() == 3) {
                    ++this.noValueAnomaly;
                }
                if (e.getCategory() != 4) continue;
                ++this.confAnomaly;
            }
            finally {
                ++this.total;
                JPA.clear();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createLeaveManagement(Employee employee) throws AxelorException {
        this.batch = (Batch)((Object)this.batchRepo.find(this.batch.getId()));
        LeaveLine leaveLine = null;
        LeaveReason leaveReason = this.batch.getHrBatch().getLeaveReason();
        if (employee != null) {
            leaveLine = ((LeaveService)this.leaveServiceProvider.get()).addLeaveReasonOrCreateIt(employee, leaveReason);
            BigDecimal dayNumber = this.batch.getHrBatch().getUseWeeklyPlanningCoef() != false ? this.batch.getHrBatch().getDayNumber().multiply(employee.getWeeklyPlanning().getLeaveCoef()) : this.batch.getHrBatch().getDayNumber();
            dayNumber = dayNumber.subtract(new BigDecimal(this.publicHolidayService.getImposedDayNumber(employee, this.batch.getHrBatch().getStartDate(), this.batch.getHrBatch().getEndDate())));
            LeaveManagement leaveManagement = this.leaveManagementService.createLeaveManagement(leaveLine, AuthUtils.getUser(), this.batch.getHrBatch().getComments(), null, this.batch.getHrBatch().getStartDate(), this.batch.getHrBatch().getEndDate(), dayNumber);
            BigDecimal qty = leaveLine.getQuantity().add(dayNumber);
            BigDecimal totalQty = leaveLine.getTotalQuantity().add(dayNumber);
            try {
                int integer = LeaveLine.class.getDeclaredField("quantity").getAnnotation(Digits.class).integer();
                BigDecimal limit = new BigDecimal((long)Math.pow(10.0, integer));
                if (qty.compareTo(limit) >= 0 || totalQty.compareTo(limit) >= 0) {
                    throw new AxelorException((Model)((Object)employee), 4, I18n.get((String)"Qty must be lower than %d."), new Object[]{limit.longValue()});
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new AxelorException((Throwable)e, 4);
            }
            leaveLine.setQuantity(qty.setScale(4, RoundingMode.HALF_EVEN));
            leaveLine.setTotalQuantity(totalQty.setScale(4, RoundingMode.HALF_EVEN));
            this.leaveManagementRepository.save((Model)((Object)leaveManagement));
            this.leaveLineRepository.save((Model)((Object)leaveLine));
            this.updateEmployee(employee);
        }
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Employees' leaves attempted to be computed : %s"), this.total) + '\n';
        comment = comment + String.format(I18n.get((String)"Employees' leaves successfully computed : %s"), this.batch.getDone()) + '\n';
        if (this.confAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Employees' leaves failed to be computed due to configuration anomaly : %s"), this.confAnomaly) + '\n';
        }
        if (this.noValueAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Employees' leaves failed to be computed due to missing data : %s"), this.noValueAnomaly) + '\n';
        }
        this.addComment(comment);
        super.stop();
    }
}

