/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.repo.LeaveLineRepository;
import com.axelor.apps.hr.db.repo.LeaveManagementRepository;
import com.axelor.apps.hr.service.batch.BatchLeaveManagement;
import com.axelor.apps.hr.service.leave.management.LeaveManagementService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class BatchLeaveManagementReset
extends BatchLeaveManagement {
    @Inject
    public BatchLeaveManagementReset(LeaveManagementService leaveManagementService, LeaveLineRepository leaveLineRepository, LeaveManagementRepository leaveManagementRepository) {
        super(leaveManagementService, leaveLineRepository, leaveManagementRepository);
    }

    @Override
    protected void process() {
        List<Employee> employeeList = this.getEmployees(this.batch.getHrBatch());
        this.resetLeaveManagementLines(employeeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLeaveManagementLines(List<Employee> employeeList) {
        for (Employee employee : employeeList) {
            try {
                this.resetLeaveManagement((Employee)((Object)this.employeeRepository.find(employee.getId())));
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e, (String)"leaveManagement", (long)this.batch.getId());
                this.incrementAnomaly();
                if (e.getCategory() == 3) {
                    ++this.noValueAnomaly;
                }
                if (e.getCategory() != 4) continue;
                ++this.confAnomaly;
            }
            finally {
                ++this.total;
                JPA.clear();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void resetLeaveManagement(Employee employee) throws AxelorException {
        LeaveReason leaveReason = this.batch.getHrBatch().getLeaveReason();
        for (LeaveLine leaveLine : employee.getLeaveLineList()) {
            if (!leaveReason.equals((Object)leaveLine.getLeaveReason())) continue;
            this.leaveManagementService.reset(leaveLine, AuthUtils.getUser(), this.batch.getHrBatch().getComments(), null, this.batch.getHrBatch().getStartDate(), this.batch.getHrBatch().getEndDate());
        }
    }
}

