/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.apps.hr.db.repo.HrBatchRepository;
import com.axelor.apps.hr.db.repo.PayrollPreparationRepository;
import com.axelor.apps.hr.service.PayrollPreparationService;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPayrollPreparationGeneration
extends BatchStrategy {
    protected final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int duplicateAnomaly;
    protected int configurationAnomaly;
    protected int total;
    protected HrBatch hrBatch;
    protected Company company;
    protected PayrollPreparationService payrollPreparationService;
    @Inject
    protected PayrollPreparationRepository payrollPreparationRepository;
    @Inject
    protected CompanyRepository companyRepository;
    @Inject
    protected PeriodRepository periodRepository;

    @Inject
    public BatchPayrollPreparationGeneration(PayrollPreparationService payrollPreparationService) {
        this.payrollPreparationService = payrollPreparationService;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        this.duplicateAnomaly = 0;
        this.configurationAnomaly = 0;
        this.total = 0;
        this.hrBatch = (HrBatch)((Object)((HrBatchRepository)((Object)Beans.get(HrBatchRepository.class))).find(this.batch.getHrBatch().getId()));
        if (this.hrBatch.getCompany() != null) {
            this.company = (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).find(this.hrBatch.getCompany().getId()));
        }
        this.checkPoint();
    }

    protected void process() {
        List<Employee> employeeList = this.getEmployees(this.hrBatch);
        this.generatePayrollPreparations(employeeList);
    }

    public List<Employee> getEmployees(HrBatch hrBatch) {
        String liaison;
        ArrayList query = Lists.newArrayList();
        if (!hrBatch.getEmployeeSet().isEmpty()) {
            String employeeIds = Joiner.on((char)',').join(Iterables.transform(hrBatch.getEmployeeSet(), obj -> obj.getId().toString()));
            query.add("self.id IN (" + employeeIds + ")");
        }
        if (!hrBatch.getPlanningSet().isEmpty()) {
            String planningIds = Joiner.on((char)',').join(Iterables.transform(hrBatch.getPlanningSet(), obj -> obj.getId().toString()));
            query.add("self.weeklyPlanning.id IN (" + planningIds + ")");
        }
        String string = liaison = query.isEmpty() ? "" : " AND";
        if (hrBatch.getCompany() != null) {
            return JPA.all(Employee.class).filter(Joiner.on((String)" AND ").join((Iterable)query) + liaison + " self.mainEmploymentContract.payCompany = :company").bind("company", (Object)hrBatch.getCompany()).fetch();
        }
        return JPA.all(Employee.class).filter(Joiner.on((String)" AND ").join((Iterable)query)).fetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePayrollPreparations(List<Employee> employeeList) {
        for (Employee employee : employeeList) {
            try {
                if ((employee = (Employee)((Object)this.employeeRepository.find(employee.getId()))).getMainEmploymentContract() == null || employee.getMainEmploymentContract().getStatus() == 3) continue;
                this.createPayrollPreparation(employee);
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e, (String)"leaveManagement", (long)this.batch.getId());
                this.incrementAnomaly();
                if (e.getCategory() == 2) {
                    ++this.duplicateAnomaly;
                    continue;
                }
                if (e.getCategory() != 4) continue;
                ++this.configurationAnomaly;
            }
            finally {
                ++this.total;
                JPA.clear();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createPayrollPreparation(Employee employee) throws AxelorException {
        String filter = "self.period = ?1 AND self.employee = ?2";
        String companyFilter = filter + " AND self.company = ?3";
        List payrollPreparationList = this.payrollPreparationRepository.all().filter(this.company != null ? companyFilter : filter, new Object[]{this.hrBatch.getPeriod(), employee, this.company}).fetch();
        this.log.debug("list : " + payrollPreparationList);
        if (!payrollPreparationList.isEmpty()) {
            throw new AxelorException((Model)((Object)employee), 2, I18n.get((String)"There is already a payroll preparation for the employee %s, the company %s and the period %s"), new Object[]{employee.getName(), this.company != null ? this.hrBatch.getCompany().getName() : null, this.hrBatch.getPeriod().getName()});
        }
        PayrollPreparation payrollPreparation = new PayrollPreparation();
        if (this.company != null) {
            Company currentCompany = (Company)((Object)this.companyRepository.find(this.company.getId()));
            payrollPreparation.setCompany(currentCompany);
        } else {
            payrollPreparation.setCompany(employee.getMainEmploymentContract().getPayCompany());
        }
        Period period = (Period)((Object)this.periodRepository.find(this.hrBatch.getPeriod().getId()));
        payrollPreparation.setEmployee(employee);
        payrollPreparation.setEmploymentContract(employee.getMainEmploymentContract());
        payrollPreparation.setPeriod(period);
        this.payrollPreparationService.fillInPayrollPreparation(payrollPreparation);
        this.payrollPreparationRepository.save((Model)((Object)payrollPreparation));
        this.updateEmployee(employee);
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Payroll preparations attempted to be generated : %s") + '\n', this.total);
        comment = comment + String.format(I18n.get((String)"Payroll preparations successfully generated : %s") + '\n', this.batch.getDone());
        if (this.duplicateAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Payroll preparations failed to be generated due to a duplicate one : %s") + '\n', this.duplicateAnomaly);
        }
        if (this.configurationAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Payroll preparations failed to be generated due to missing data : %s") + '\n', this.configurationAnomaly);
        }
        this.addComment(comment);
        super.stop();
    }
}

