/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveManagement;
import com.axelor.apps.hr.db.LeaveManagementBatchRule;
import com.axelor.apps.hr.db.repo.HRConfigRepository;
import com.axelor.apps.hr.db.repo.LeaveLineRepository;
import com.axelor.apps.hr.db.repo.LeaveManagementRepository;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.hr.service.employee.EmployeeService;
import com.axelor.apps.hr.service.leave.management.LeaveManagementService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.tool.template.TemplateMaker;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class BatchSeniorityLeaveManagement
extends BatchStrategy {
    int total;
    int noValueAnomaly;
    int confAnomaly;
    private static final char TEMPLATE_DELIMITER = '$';
    protected TemplateMaker maker;
    protected HRConfig hrConfig;
    protected LeaveLineRepository leaveLineRepository;
    protected LeaveManagementRepository leaveManagementRepository;

    @Inject
    public BatchSeniorityLeaveManagement(LeaveManagementService leaveManagementService, LeaveLineRepository leaveLineRepository, LeaveManagementRepository leaveManagementRepository) {
        super(leaveManagementService);
        this.leaveLineRepository = leaveLineRepository;
        this.leaveManagementRepository = leaveManagementRepository;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        if (this.batch.getHrBatch().getDayNumber() == null || this.batch.getHrBatch().getDayNumber() == BigDecimal.ZERO || this.batch.getHrBatch().getLeaveReason() == null) {
            TraceBackService.trace((AxelorException)new AxelorException(4, I18n.get((String)"Leave reason and day number have to be defined")), (String)"leaveManagement", (long)this.batch.getId());
        }
        this.total = 0;
        this.noValueAnomaly = 0;
        this.confAnomaly = 0;
        this.maker = new TemplateMaker(Locale.FRENCH, '$', '$');
        this.hrConfig = (HRConfig)((Object)((HRConfigRepository)((Object)Beans.get(HRConfigRepository.class))).all().filter("self.company.id = ?1 ", new Object[]{this.batch.getHrBatch().getCompany().getId()}).fetchOne());
        this.checkPoint();
    }

    protected void process() {
        List<Employee> employeeList = this.getEmployees(this.batch.getHrBatch());
        this.generateLeaveManagementLines(employeeList);
    }

    public List<Employee> getEmployees(HrBatch hrBatch) {
        List employeeList = hrBatch.getCompany() != null ? JPA.all(Employee.class).filter("self.mainEmploymentContract.payCompany = :company").bind("company", (Object)hrBatch.getCompany()).fetch() : JPA.all(Employee.class).fetch();
        return employeeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateLeaveManagementLines(List<Employee> employeeList) {
        for (Employee employee : employeeList) {
            try {
                this.createLeaveManagement((Employee)((Object)this.employeeRepository.find(employee.getId())));
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e, (String)"leaveManagement", (long)this.batch.getId());
                this.incrementAnomaly();
                if (e.getCategory() == 3) {
                    ++this.noValueAnomaly;
                }
                if (e.getCategory() != 4) continue;
                ++this.confAnomaly;
            }
            finally {
                ++this.total;
                JPA.clear();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createLeaveManagement(Employee employee) throws AxelorException {
        this.batch = (Batch)((Object)this.batchRepo.find(this.batch.getId()));
        int count = 0;
        String eval = null;
        LeaveLine leaveLine = null;
        BigDecimal quantity = BigDecimal.ZERO;
        if (!employee.getLeaveLineList().isEmpty()) {
            for (LeaveLine line : employee.getLeaveLineList()) {
                if (!line.getLeaveReason().equals((Object)this.batch.getHrBatch().getLeaveReason())) continue;
                ++count;
                leaveLine = line;
            }
        }
        if (count == 0) {
            throw new AxelorException((Model)((Object)employee), 3, I18n.get((String)"The employee %s has no %s leave line"), new Object[]{employee.getName(), this.batch.getHrBatch().getLeaveReason().getLeaveReason()});
        }
        if (count > 1) {
            throw new AxelorException((Model)((Object)employee), 4, I18n.get((String)"The employee %s has multiple %s leave lines"), new Object[]{employee.getName(), this.batch.getHrBatch().getLeaveReason().getLeaveReason()});
        }
        if (count == 1) {
            EmploymentContract contract = employee.getMainEmploymentContract();
            if (contract == null) {
                throw new AxelorException(3, "Please, add a contract of employment for employee : %s");
            }
            Integer executiveStatusSelect = contract.getExecutiveStatusSelect();
            for (LeaveManagementBatchRule rule : ((HRConfig)((Object)((HRConfigRepository)((Object)Beans.get(HRConfigRepository.class))).all().filter("self.company.id = ?1", new Object[]{this.batch.getHrBatch().getCompany().getId()}).fetchOne())).getLeaveManagementBatchRuleList()) {
                if (!rule.getExecutiveStatusSelect().equals(executiveStatusSelect)) continue;
                this.maker.setContext((Model)((Object)employee), "Employee");
                String formula = rule.getFormula();
                formula = formula.replace(this.hrConfig.getSeniorityVariableName(), String.valueOf(((EmployeeService)Beans.get(EmployeeService.class)).getLengthOfService(employee, this.batch.getHrBatch().getReferentialDate())));
                formula = formula.replace(this.hrConfig.getAgeVariableName(), String.valueOf(((EmployeeService)Beans.get(EmployeeService.class)).getAge(employee, this.batch.getHrBatch().getReferentialDate())));
                this.maker.setTemplate(formula);
                eval = this.maker.make();
                CompilerConfiguration conf = new CompilerConfiguration();
                ImportCustomizer customizer = new ImportCustomizer();
                customizer.addStaticStars(new String[]{"java.lang.Math"});
                conf.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
                Binding binding = new Binding();
                GroovyShell shell = new GroovyShell(binding, conf);
                if (!shell.evaluate(eval).toString().equals("true")) continue;
                quantity = rule.getLeaveDayNumber();
                break;
            }
            if (quantity.signum() == 0) {
                this.incrementDone();
                return;
            }
            LeaveManagement leaveManagement = this.leaveManagementService.createLeaveManagement(leaveLine, AuthUtils.getUser(), this.batch.getHrBatch().getComments(), null, this.batch.getHrBatch().getStartDate(), this.batch.getHrBatch().getEndDate(), quantity);
            leaveLine.setQuantity(leaveLine.getQuantity().add(quantity));
            leaveLine.setTotalQuantity(leaveLine.getTotalQuantity().add(quantity));
            this.leaveManagementRepository.save((Model)((Object)leaveManagement));
            this.leaveLineRepository.save((Model)((Object)leaveLine));
            this.updateEmployee(employee);
        }
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Employees' leaves attempted to be computed : %s") + '\n', this.total);
        comment = comment + String.format(I18n.get((String)"Employees' leaves successfully computed : %s") + '\n', this.batch.getDone());
        if (this.confAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Employees' leaves failed to be computed due to configuration anomaly : %s") + '\n', this.confAnomaly);
        }
        if (this.noValueAnomaly > 0) {
            comment = comment + String.format(I18n.get((String)"Employees' leaves failed to be computed due to missing data : %s") + '\n', this.noValueAnomaly);
        }
        this.addComment(comment);
        super.stop();
    }
}

