/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.hr.service.leave.management.LeaveManagementService;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;

public class BatchTimesheetReminder
extends BatchStrategy {
    protected TimesheetRepository timesheetRepo;
    protected MessageService messageService;

    @Inject
    public BatchTimesheetReminder(LeaveManagementService leaveManagementService, TimesheetRepository timesheetRepo, MessageService messageService) {
        super(leaveManagementService);
        this.timesheetRepo = timesheetRepo;
        this.messageService = messageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        for (Employee employee : this.getEmployeesWithoutRecentTimesheet()) {
            try {
                this.sendReminder(employee);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e, (String)Employee.class.getSimpleName(), (long)this.batch.getId());
                this.incrementAnomaly();
            }
            finally {
                this.incrementDone();
            }
        }
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Employees computed: %d"), this.batch.getDone()) + "<br/>" + String.format(I18n.get((String)"Employees failed to be computed due to anomaly: %d"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }

    private List<Employee> getEmployeesWithoutRecentTimesheet() {
        LocalDate now = LocalDate.now();
        long daysBeforeReminder = this.batch.getHrBatch().getDaysBeforeReminder();
        List employees = this.employeeRepository.all().filter("self.timesheetReminder = 't' AND self.mainEmploymentContract.payCompany = :companyId").bind("companyId", (Object)this.batch.getHrBatch().getCompany().getId()).fetch();
        employees.removeIf(employee -> this.hasRecentTimesheet(now, daysBeforeReminder, (Employee)((Object)employee)));
        return employees;
    }

    private boolean hasRecentTimesheet(LocalDate now, long daysBeforeReminder, Employee employee) {
        Timesheet timesheet = (Timesheet)((Object)this.timesheetRepo.all().filter("self.user.id = :userId AND self.statusSelect IN (:confirmed, :validated) AND self.company = :companyId").bind("userId", (Object)employee.getUser().getId()).bind("confirmed", (Object)2).bind("validated", (Object)3).bind("companyId", (Object)this.batch.getHrBatch().getCompany().getId()).order("-toDate").fetchOne());
        return timesheet != null && timesheet.getToDate().plusDays(daysBeforeReminder).isAfter(now);
    }

    private void sendReminder(Employee employee) throws AxelorException, MessagingException, IOException {
        Message message = new Message();
        message.setMediaTypeSelect(2);
        message.setReplyToEmailAddressSet(new HashSet<EmailAddress>());
        message.setCcEmailAddressSet(new HashSet<EmailAddress>());
        message.setBccEmailAddressSet(new HashSet<EmailAddress>());
        message.addToEmailAddressSetItem(employee.getContactPartner().getEmailAddress());
        message.setSenderUser(AuthUtils.getUser());
        message.setSubject(this.batch.getHrBatch().getTemplate().getSubject());
        message.setContent(this.batch.getHrBatch().getTemplate().getContent());
        message.setMailAccount((EmailAccount)((Object)((EmailAccountRepository)((Object)Beans.get(EmailAccountRepository.class))).all().filter("self.isDefault = true").fetchOne()));
        this.messageService.sendByEmail(message);
    }
}

