/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.administration.AbstractBatchService;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.service.batch.BatchEmploymentContractExport;
import com.axelor.apps.hr.service.batch.BatchLeaveManagement;
import com.axelor.apps.hr.service.batch.BatchLeaveManagementReset;
import com.axelor.apps.hr.service.batch.BatchPayrollPreparationExport;
import com.axelor.apps.hr.service.batch.BatchPayrollPreparationGeneration;
import com.axelor.apps.hr.service.batch.BatchSeniorityLeaveManagement;
import com.axelor.apps.hr.service.batch.BatchTimesheetReminder;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;

public class HrBatchService
extends AbstractBatchService {
    protected Class<? extends Model> getModelClass() {
        return HrBatch.class;
    }

    public Batch run(Model batchModel) throws AxelorException {
        HrBatch hrBatch = (HrBatch)((Object)batchModel);
        Batch batch = null;
        switch (hrBatch.getActionSelect()) {
            case 1: {
                batch = this.leaveManagement(hrBatch);
                break;
            }
            case 2: {
                batch = this.seniorityLeaveManagement(hrBatch);
                break;
            }
            case 3: {
                batch = this.payrollPreparationGeneration(hrBatch);
                break;
            }
            case 4: {
                batch = this.payrollPreparationExport(hrBatch);
                break;
            }
            case 5: {
                batch = this.leaveManagementReset(hrBatch);
                break;
            }
            case 6: {
                batch = this.employmentContractExport(hrBatch);
                break;
            }
            case 7: {
                batch = this.runTimesheetReminderBatch(hrBatch);
                break;
            }
            default: {
                throw new AxelorException(5, I18n.get((String)"Unknown action %s for the %s treatment"), new Object[]{hrBatch.getActionSelect(), hrBatch.getCode()});
            }
        }
        return batch;
    }

    public Batch leaveManagement(HrBatch hrBatch) {
        return ((BatchLeaveManagement)((Object)Beans.get(BatchLeaveManagement.class))).run(hrBatch);
    }

    public Batch seniorityLeaveManagement(HrBatch hrBatch) {
        return ((BatchSeniorityLeaveManagement)((Object)Beans.get(BatchSeniorityLeaveManagement.class))).run(hrBatch);
    }

    public Batch payrollPreparationGeneration(HrBatch hrBatch) {
        return ((BatchPayrollPreparationGeneration)((Object)Beans.get(BatchPayrollPreparationGeneration.class))).run(hrBatch);
    }

    public Batch payrollPreparationExport(HrBatch hrBatch) {
        return ((BatchPayrollPreparationExport)((Object)Beans.get(BatchPayrollPreparationExport.class))).run(hrBatch);
    }

    public Batch leaveManagementReset(HrBatch hrBatch) {
        return ((BatchLeaveManagementReset)((Object)Beans.get(BatchLeaveManagementReset.class))).run(hrBatch);
    }

    public Batch employmentContractExport(HrBatch hrBatch) {
        return ((BatchEmploymentContractExport)((Object)Beans.get(BatchEmploymentContractExport.class))).run(hrBatch);
    }

    public Batch runTimesheetReminderBatch(HrBatch hrBatch) throws AxelorException {
        if (hrBatch.getTemplate() == null) {
            throw new AxelorException(3, "You must choose a template.");
        }
        return ((BatchTimesheetReminder)((Object)Beans.get(BatchTimesheetReminder.class))).run(hrBatch);
    }
}

