/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.config;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.message.db.Template;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;

public class HRConfigService {
    public HRConfig getHRConfig(Company company) throws AxelorException {
        HRConfig hrConfig = company.getHrConfig();
        if (hrConfig == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure informations for human resources for the company %s"), new Object[]{company.getName()});
        }
        return hrConfig;
    }

    public Sequence getExpenseSequence(HRConfig hrConfig) throws AxelorException {
        Sequence sequence = hrConfig.getExpenseSequence();
        if (sequence == null) {
            throw new AxelorException(4, I18n.get((String)"Company %s does not have any expense's sequence"), new Object[]{hrConfig.getCompany().getName()});
        }
        return sequence;
    }

    public LeaveReason getLeaveReason(HRConfig hrConfig) throws AxelorException {
        LeaveReason leaveReason = hrConfig.getToJustifyLeaveReason();
        if (leaveReason == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the unjustified absence reason in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return leaveReason;
    }

    public Product getKilometricExpenseProduct(HRConfig hrConfig) throws AxelorException {
        Product kilometricExpenseProduct = hrConfig.getKilometricExpenseProduct();
        if (kilometricExpenseProduct == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the expense type for kilometric allowance in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return kilometricExpenseProduct;
    }

    public Template getSentExpenseTemplate(HRConfig hrConfig) throws AxelorException {
        Template sentExpenseTemplate = hrConfig.getSentExpenseTemplate();
        if (sentExpenseTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the sent expense template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return sentExpenseTemplate;
    }

    public Template getValidatedExpenseTemplate(HRConfig hrConfig) throws AxelorException {
        Template validatedExpenseTemplate = hrConfig.getValidatedExpenseTemplate();
        if (validatedExpenseTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the validated expense template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return validatedExpenseTemplate;
    }

    public Template getRefusedExpenseTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedExpenseTemplate = hrConfig.getRefusedExpenseTemplate();
        if (refusedExpenseTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the refused expense template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedExpenseTemplate;
    }

    public Template getCanceledExpenseTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedExpenseTemplate = hrConfig.getCanceledExpenseTemplate();
        if (refusedExpenseTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the canceled expense template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedExpenseTemplate;
    }

    public Template getSentTimesheetTemplate(HRConfig hrConfig) throws AxelorException {
        Template sentTimesheetTemplate = hrConfig.getSentTimesheetTemplate();
        if (sentTimesheetTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the sent timehsheet template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return sentTimesheetTemplate;
    }

    public Template getValidatedTimesheetTemplate(HRConfig hrConfig) throws AxelorException {
        Template validatedTimesheetTemplate = hrConfig.getValidatedTimesheetTemplate();
        if (validatedTimesheetTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the validated timehsheet template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return validatedTimesheetTemplate;
    }

    public Template getRefusedTimesheetTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedTimesheetTemplate = hrConfig.getRefusedTimesheetTemplate();
        if (refusedTimesheetTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the refused timehsheet template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedTimesheetTemplate;
    }

    public Template getCanceledTimesheetTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedTimesheetTemplate = hrConfig.getCanceledTimesheetTemplate();
        if (refusedTimesheetTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the canceled timehsheet template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedTimesheetTemplate;
    }

    public Template getSentLeaveTemplate(HRConfig hrConfig) throws AxelorException {
        Template sentLeaveTemplate = hrConfig.getSentLeaveTemplate();
        if (sentLeaveTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the sent leave template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return sentLeaveTemplate;
    }

    public Template getValidatedLeaveTemplate(HRConfig hrConfig) throws AxelorException {
        Template validatedLeaveTemplate = hrConfig.getValidatedLeaveTemplate();
        if (validatedLeaveTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the validated leave template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return validatedLeaveTemplate;
    }

    public Template getRefusedLeaveTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedLeaveTemplate = hrConfig.getRefusedLeaveTemplate();
        if (refusedLeaveTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the refused leave template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedLeaveTemplate;
    }

    public Template getCanceledLeaveTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedLeaveTemplate = hrConfig.getCanceledLeaveTemplate();
        if (refusedLeaveTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the canceled leave template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedLeaveTemplate;
    }

    public Template getSentExtraHoursTemplate(HRConfig hrConfig) throws AxelorException {
        Template sentExtraHoursTemplate = hrConfig.getSentExtraHoursTemplate();
        if (sentExtraHoursTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the sent extra hours template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return sentExtraHoursTemplate;
    }

    public Template getValidatedExtraHoursTemplate(HRConfig hrConfig) throws AxelorException {
        Template validatedExtraHoursTemplate = hrConfig.getValidatedExtraHoursTemplate();
        if (validatedExtraHoursTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the validated extra hours template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return validatedExtraHoursTemplate;
    }

    public Template getRefusedExtraHoursTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedExtraHoursTemplate = hrConfig.getRefusedExtraHoursTemplate();
        if (refusedExtraHoursTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the refused extra hours template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedExtraHoursTemplate;
    }

    public Template getCanceledExtraHoursTemplate(HRConfig hrConfig) throws AxelorException {
        Template refusedExtraHoursTemplate = hrConfig.getCanceledExtraHoursTemplate();
        if (refusedExtraHoursTemplate == null) {
            throw new AxelorException(4, I18n.get((String)"Please configure the canceled extra hours template in HR config for the company %s"), new Object[]{hrConfig.getCompany().getName()});
        }
        return refusedExtraHoursTemplate;
    }
}

