/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.expense;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.message.db.Message;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.mail.MessagingException;

public interface ExpenseService {
    public ExpenseLine getAndComputeAnalyticDistribution(ExpenseLine var1, Expense var2) throws AxelorException;

    public ExpenseLine createAnalyticDistributionWithTemplate(ExpenseLine var1) throws AxelorException;

    public ExpenseLine computeAnalyticDistribution(ExpenseLine var1) throws AxelorException;

    public Expense compute(Expense var1);

    @Transactional(rollbackOn={Exception.class})
    public void confirm(Expense var1) throws AxelorException;

    public Message sendConfirmationEmail(Expense var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void validate(Expense var1) throws AxelorException;

    public Message sendValidationEmail(Expense var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void refuse(Expense var1) throws AxelorException;

    public Message sendRefusalEmail(Expense var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public Move ventilate(Expense var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancel(Expense var1) throws AxelorException;

    public Message sendCancellationEmail(Expense var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void addPayment(Expense var1, BankDetails var2) throws AxelorException;

    public void addPayment(Expense var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancelPayment(Expense var1) throws AxelorException;

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<ExpenseLine> var2, int var3) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, ExpenseLine var2, int var3) throws AxelorException;

    public Expense getOrCreateExpense(User var1);

    public BigDecimal computePersonalExpenseAmount(Expense var1);

    public BigDecimal computeAdvanceAmount(Expense var1);

    public Product getKilometricExpenseProduct(Expense var1) throws AxelorException;

    public void setDraftSequence(Expense var1) throws AxelorException;

    public List<KilometricAllowParam> getListOfKilometricAllowParamVehicleFilter(ExpenseLine var1) throws AxelorException;

    public List<ExpenseLine> getExpenseLineList(Expense var1);

    public void completeExpenseLines(Expense var1);

    public List<KilometricAllowParam> getListOfKilometricAllowParamVehicleFilter(ExpenseLine var1, Expense var2) throws AxelorException;

    public Move createMoveForExpensePayment(Expense var1) throws AxelorException;

    public Expense updateMoveDateAndPeriod(Expense var1);
}

