/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.leave;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.DayPlanning;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.db.repo.ICalendarEventRepository;
import com.axelor.apps.base.ical.ICalendarService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.repo.LeaveLineRepository;
import com.axelor.apps.hr.db.repo.LeaveRequestRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.publicHoliday.PublicHolidayHrService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import javax.mail.MessagingException;

public class LeaveServiceImpl
implements LeaveService {
    protected LeaveLineRepository leaveLineRepo;
    protected WeeklyPlanningService weeklyPlanningService;
    protected PublicHolidayHrService publicHolidayHrService;
    protected LeaveRequestRepository leaveRequestRepo;
    protected AppBaseService appBaseService;
    protected HRConfigService hrConfigService;
    protected TemplateMessageService templateMessageService;
    protected ICalendarEventRepository icalEventRepo;
    protected ICalendarService icalendarService;

    @Inject
    public LeaveServiceImpl(LeaveLineRepository leaveLineRepo, WeeklyPlanningService weeklyPlanningService, PublicHolidayHrService publicHolidayHrService, LeaveRequestRepository leaveRequestRepo, AppBaseService appBaseService, HRConfigService hrConfigService, TemplateMessageService templateMessageService, ICalendarEventRepository icalEventRepo, ICalendarService icalendarService) {
        this.leaveLineRepo = leaveLineRepo;
        this.weeklyPlanningService = weeklyPlanningService;
        this.publicHolidayHrService = publicHolidayHrService;
        this.leaveRequestRepo = leaveRequestRepo;
        this.appBaseService = appBaseService;
        this.hrConfigService = hrConfigService;
        this.templateMessageService = templateMessageService;
        this.icalEventRepo = icalEventRepo;
        this.icalendarService = icalendarService;
    }

    @Override
    public BigDecimal computeDuration(LeaveRequest leave, LocalDate fromDate, LocalDate toDate) throws AxelorException {
        LocalDateTime leaveFromDate = leave.getFromDateT();
        LocalDateTime leaveToDate = leave.getToDateT();
        int startOn = leave.getStartOnSelect();
        int endOn = leave.getEndOnSelect();
        LocalDateTime from = leaveFromDate;
        LocalDateTime to = leaveToDate;
        if (leaveFromDate.toLocalDate().isBefore(fromDate)) {
            from = fromDate.atStartOfDay();
            startOn = 1;
        }
        if (leaveToDate.toLocalDate().isAfter(toDate)) {
            to = toDate.atStartOfDay();
            endOn = 2;
        }
        return this.computeDuration(leave, from, to, startOn, endOn);
    }

    @Override
    public BigDecimal computeDuration(LeaveRequest leave) throws AxelorException {
        return this.computeDuration(leave, leave.getFromDateT(), leave.getToDateT(), leave.getStartOnSelect(), leave.getEndOnSelect());
    }

    @Override
    public BigDecimal computeDuration(LeaveRequest leave, LocalDateTime from, LocalDateTime to, int startOn, int endOn) throws AxelorException {
        BigDecimal duration = BigDecimal.ZERO;
        if (from != null && to != null && leave.getLeaveLine() != null && leave.getLeaveLine().getLeaveReason() != null) {
            Employee employee = leave.getUser().getEmployee();
            if (employee == null) {
                throw new AxelorException(4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
            }
            switch (leave.getLeaveLine().getLeaveReason().getUnitSelect()) {
                case 1: {
                    LocalDate fromDate = from.toLocalDate();
                    LocalDate toDate = to.toLocalDate();
                    duration = this.computeDurationInDays(leave, employee, fromDate, toDate, startOn, endOn);
                    break;
                }
                case 2: {
                    duration = this.computeDurationInHours(leave, employee, from, to);
                    break;
                }
                default: {
                    throw new AxelorException((Model)((Object)leave.getLeaveLine().getLeaveReason()), 3, I18n.get((String)"Please, choose unit in leave reason %s."), new Object[]{leave.getLeaveLine().getLeaveReason().getLeaveReason()});
                }
            }
        }
        return duration.signum() != -1 ? duration : BigDecimal.ZERO;
    }

    protected BigDecimal computeDurationInDays(LeaveRequest leave, Employee employee, LocalDate fromDate, LocalDate toDate, int startOn, int endOn) throws AxelorException {
        BigDecimal duration = BigDecimal.ZERO;
        WeeklyPlanning weeklyPlanning = this.getWeeklyPlanning(leave, employee);
        EventsPlanning holidayPlanning = this.getPublicHolidayEventsPlanning(leave, employee);
        if (fromDate.isEqual(toDate)) {
            duration = startOn == endOn ? (startOn == 1 ? duration.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDaysWithSelect(weeklyPlanning, fromDate, true, false))) : duration.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDaysWithSelect(weeklyPlanning, fromDate, false, true)))) : duration.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDaysWithSelect(weeklyPlanning, fromDate, true, true)));
        } else {
            duration = duration.add(BigDecimal.valueOf(this.computeStartDateWithSelect(fromDate, startOn, weeklyPlanning)));
            LocalDate itDate = fromDate.plusDays(1L);
            while (!itDate.isEqual(toDate) && !itDate.isAfter(toDate)) {
                duration = duration.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, itDate)));
                itDate = itDate.plusDays(1L);
            }
            duration = duration.add(BigDecimal.valueOf(this.computeEndDateWithSelect(toDate, endOn, weeklyPlanning)));
        }
        if (holidayPlanning != null) {
            duration = duration.subtract(this.publicHolidayHrService.computePublicHolidayDays(fromDate, toDate, weeklyPlanning, holidayPlanning));
        }
        return duration;
    }

    protected BigDecimal computeDurationInHours(LeaveRequest leave, Employee employee, LocalDateTime fromDateT, LocalDateTime toDateT) throws AxelorException {
        BigDecimal duration = BigDecimal.ZERO;
        WeeklyPlanning weeklyPlanning = this.getWeeklyPlanning(leave, employee);
        EventsPlanning holidayPlanning = this.getPublicHolidayEventsPlanning(leave, employee);
        LocalDate fromDate = fromDateT.toLocalDate();
        LocalDate toDate = toDateT.toLocalDate();
        if (toDate.equals(fromDate) && !this.publicHolidayHrService.checkPublicHolidayDay(fromDate, holidayPlanning)) {
            duration = duration.add(this.weeklyPlanningService.getWorkingDayValueInHours(weeklyPlanning, fromDate, fromDateT.toLocalTime(), toDateT.toLocalTime()));
        } else {
            if (!this.publicHolidayHrService.checkPublicHolidayDay(fromDate, holidayPlanning)) {
                duration = duration.add(this.weeklyPlanningService.getWorkingDayValueInHours(weeklyPlanning, fromDate, fromDateT.toLocalTime(), null));
            }
            fromDate = fromDate.plusDays(1L);
            if (!this.publicHolidayHrService.checkPublicHolidayDay(toDate, holidayPlanning)) {
                duration = duration.add(this.weeklyPlanningService.getWorkingDayValueInHours(weeklyPlanning, toDate, null, toDateT.toLocalTime()));
            }
            LocalDate date = fromDate;
            while (date.isBefore(toDate)) {
                if (!this.publicHolidayHrService.checkPublicHolidayDay(date, holidayPlanning)) {
                    duration = duration.add(this.weeklyPlanningService.getWorkingDayValueInHours(weeklyPlanning, date, null, null));
                }
                date = date.plusDays(1L);
            }
        }
        return duration;
    }

    protected WeeklyPlanning getWeeklyPlanning(LeaveRequest leave, Employee employee) throws AxelorException {
        HRConfig conf;
        Company comp;
        WeeklyPlanning weeklyPlanning = employee.getWeeklyPlanning();
        if (weeklyPlanning == null && (comp = leave.getCompany()) != null && (conf = comp.getHrConfig()) != null) {
            weeklyPlanning = conf.getWeeklyPlanning();
        }
        if (weeklyPlanning == null) {
            throw new AxelorException(4, I18n.get((String)"Please, add a planning for employee : %s"), new Object[]{employee.getName()});
        }
        return weeklyPlanning;
    }

    protected EventsPlanning getPublicHolidayEventsPlanning(LeaveRequest leave, Employee employee) {
        EventsPlanning publicHolidayPlanning = employee.getPublicHolidayEventsPlanning();
        if (publicHolidayPlanning == null && leave.getCompany() != null && leave.getCompany().getHrConfig() != null) {
            publicHolidayPlanning = leave.getCompany().getHrConfig().getPublicHolidayEventsPlanning();
        }
        return publicHolidayPlanning;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void manageSentLeaves(LeaveRequest leave) throws AxelorException {
        Employee employee = leave.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
        }
        LeaveLine leaveLine = (LeaveLine)((Object)this.leaveLineRepo.all().filter("self.employee = ?1 AND self.leaveReason = ?2", new Object[]{employee, leave.getLeaveLine().getLeaveReason()}).fetchOne());
        if (leaveLine == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"There is no leave line for the employee %s and the reason %s."), new Object[]{employee.getName(), leave.getLeaveLine().getLeaveReason().getLeaveReason()});
        }
        if (leave.getInjectConsumeSelect() == 1) {
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().subtract(leave.getDuration()));
        } else {
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().add(leave.getDuration()));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void manageValidateLeaves(LeaveRequest leave) throws AxelorException {
        Employee employee = leave.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
        }
        LeaveLine leaveLine = (LeaveLine)((Object)this.leaveLineRepo.all().filter("self.employee = ?1 AND self.leaveReason = ?2", new Object[]{employee, leave.getLeaveLine().getLeaveReason()}).fetchOne());
        if (leaveLine == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"There is no leave line for the employee %s and the reason %s."), new Object[]{employee.getName(), leave.getLeaveLine().getLeaveReason().getLeaveReason()});
        }
        if (leave.getInjectConsumeSelect() == 1) {
            leaveLine.setQuantity(leaveLine.getQuantity().subtract(leave.getDuration()));
            if (leaveLine.getQuantity().signum() == -1 && !employee.getNegativeValueLeave().booleanValue()) {
                throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Employee %s is not allowed to take leave in advance."), new Object[]{employee.getName()});
            }
            if (leaveLine.getQuantity().signum() == -1 && !leave.getLeaveLine().getLeaveReason().getAllowNegativeValue().booleanValue()) {
                throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"You are not able to take leave in advance for the reason '%s'."), new Object[]{leave.getLeaveLine().getLeaveReason().getLeaveReason()});
            }
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().add(leave.getDuration()));
            leaveLine.setDaysValidated(leaveLine.getDaysValidated().add(leave.getDuration()));
        } else {
            leaveLine.setQuantity(leaveLine.getQuantity().add(leave.getDuration()));
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().subtract(leave.getDuration()));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void manageRefuseLeaves(LeaveRequest leave) throws AxelorException {
        Employee employee = leave.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
        }
        LeaveLine leaveLine = (LeaveLine)((Object)this.leaveLineRepo.all().filter("self.employee = ?1 AND self.leaveReason = ?2", new Object[]{employee, leave.getLeaveLine().getLeaveReason()}).fetchOne());
        if (leaveLine == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"There is no leave line for the employee %s and the reason %s."), new Object[]{employee.getName(), leave.getLeaveLine().getLeaveReason().getLeaveReason()});
        }
        if (leave.getInjectConsumeSelect() == 1) {
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().add(leave.getDuration()));
        } else {
            leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().subtract(leave.getDuration()));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void manageCancelLeaves(LeaveRequest leave) throws AxelorException {
        Employee employee = leave.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
        }
        LeaveLine leaveLine = (LeaveLine)((Object)this.leaveLineRepo.all().filter("self.employee = ?1 AND self.leaveReason = ?2", new Object[]{employee, leave.getLeaveLine().getLeaveReason()}).fetchOne());
        if (leaveLine == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"There is no leave line for the employee %s and the reason %s."), new Object[]{employee.getName(), leave.getLeaveLine().getLeaveReason().getLeaveReason()});
        }
        if (leave.getStatusSelect() == 3) {
            if (leave.getInjectConsumeSelect() == 1) {
                leaveLine.setQuantity(leaveLine.getQuantity().add(leave.getDuration()));
            } else {
                leaveLine.setQuantity(leaveLine.getQuantity().subtract(leave.getDuration()));
            }
            leaveLine.setDaysValidated(leaveLine.getDaysValidated().subtract(leave.getDuration()));
        } else if (leave.getStatusSelect() == 2) {
            if (leave.getInjectConsumeSelect() == 1) {
                leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().add(leave.getDuration()));
            } else {
                leaveLine.setDaysToValidate(leaveLine.getDaysToValidate().subtract(leave.getDuration()));
            }
        }
    }

    @Override
    public double computeStartDateWithSelect(LocalDate date, int select, WeeklyPlanning weeklyPlanning) {
        double value = 0.0;
        if (select == 1) {
            value = this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, date);
        } else {
            DayPlanning dayPlanning = this.weeklyPlanningService.findDayPlanning(weeklyPlanning, date);
            if (dayPlanning != null && dayPlanning.getAfternoonFrom() != null && dayPlanning.getAfternoonTo() != null) {
                value = 0.5;
            }
        }
        return value;
    }

    @Override
    public double computeEndDateWithSelect(LocalDate date, int select, WeeklyPlanning weeklyPlanning) {
        double value = 0.0;
        if (select == 2) {
            value = this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, date);
        } else {
            DayPlanning dayPlanning = this.weeklyPlanningService.findDayPlanning(weeklyPlanning, date);
            if (dayPlanning != null && dayPlanning.getMorningFrom() != null && dayPlanning.getMorningTo() != null) {
                value = 0.5;
            }
        }
        return value;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public LeaveRequest createEvents(LeaveRequest leave) throws AxelorException {
        LocalDateTime toDateTime;
        LocalDateTime fromDateTime;
        Employee employee = leave.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{leave.getUser().getName()});
        }
        WeeklyPlanning weeklyPlanning = employee.getWeeklyPlanning();
        if (weeklyPlanning == null) {
            throw new AxelorException((Model)((Object)leave), 4, I18n.get((String)"Please, add a planning for employee : %s"), new Object[]{employee.getName()});
        }
        if (leave.getLeaveLine().getLeaveReason().getUnitSelect() == 1) {
            fromDateTime = this.getDefaultStart(weeklyPlanning, leave);
            toDateTime = this.getDefaultEnd(weeklyPlanning, leave);
        } else {
            fromDateTime = leave.getFromDateT();
            toDateTime = leave.getToDateT();
        }
        ICalendarEvent event = this.icalendarService.createEvent(fromDateTime, toDateTime, leave.getUser(), leave.getComments(), 4, leave.getLeaveLine().getLeaveReason().getLeaveReason() + " " + leave.getUser().getFullName());
        this.icalEventRepo.save((Model)event);
        leave.setIcalendarEvent(event);
        return leave;
    }

    protected LocalDateTime getDefaultStart(WeeklyPlanning weeklyPlanning, LeaveRequest leave) {
        int startTimeHour = 0;
        int startTimeMin = 0;
        DayPlanning startDay = this.weeklyPlanningService.findDayPlanning(weeklyPlanning, leave.getFromDateT().toLocalDate());
        if (leave.getStartOnSelect() == 1) {
            if (startDay != null && startDay.getMorningFrom() != null) {
                startTimeHour = startDay.getMorningFrom().getHour();
                startTimeMin = startDay.getMorningFrom().getMinute();
            } else {
                startTimeHour = 8;
                startTimeMin = 0;
            }
        } else if (startDay != null && startDay.getAfternoonFrom() != null) {
            startTimeHour = startDay.getAfternoonFrom().getHour();
            startTimeMin = startDay.getAfternoonFrom().getMinute();
        } else {
            startTimeHour = 14;
            startTimeMin = 0;
        }
        return LocalDateTime.of(leave.getFromDateT().toLocalDate(), LocalTime.of(startTimeHour, startTimeMin));
    }

    protected LocalDateTime getDefaultEnd(WeeklyPlanning weeklyPlanning, LeaveRequest leave) {
        int endTimeHour = 0;
        int endTimeMin = 0;
        DayPlanning endDay = this.weeklyPlanningService.findDayPlanning(weeklyPlanning, leave.getToDateT().toLocalDate());
        if (leave.getEndOnSelect() == 1) {
            if (endDay != null && endDay.getMorningTo() != null) {
                endTimeHour = endDay.getMorningTo().getHour();
                endTimeMin = endDay.getMorningTo().getMinute();
            } else {
                endTimeHour = 12;
                endTimeMin = 0;
            }
        } else if (endDay != null && endDay.getAfternoonTo() != null) {
            endTimeHour = endDay.getAfternoonTo().getHour();
            endTimeMin = endDay.getAfternoonTo().getMinute();
        } else {
            endTimeHour = 18;
            endTimeMin = 0;
        }
        return LocalDateTime.of(leave.getToDateT().toLocalDate(), LocalTime.of(endTimeHour, endTimeMin));
    }

    @Override
    public BigDecimal computeLeaveDaysByLeaveRequest(LocalDate fromDate, LocalDate toDate, LeaveRequest leaveRequest, Employee employee) throws AxelorException {
        BigDecimal leaveDays = BigDecimal.ZERO;
        WeeklyPlanning weeklyPlanning = employee.getWeeklyPlanning();
        LocalDate leaveFrom = leaveRequest.getFromDateT().toLocalDate();
        LocalDate leaveTo = leaveRequest.getToDateT().toLocalDate();
        LocalDate itDate = fromDate;
        if (fromDate.isBefore(leaveFrom) || fromDate.equals(leaveFrom)) {
            itDate = leaveFrom;
        }
        boolean morningHalf = false;
        boolean eveningHalf = false;
        BigDecimal daysToAdd = BigDecimal.ZERO;
        if (leaveTo.equals(leaveFrom) && leaveRequest.getStartOnSelect() == leaveRequest.getEndOnSelect()) {
            eveningHalf = leaveRequest.getStartOnSelect() == 2;
            boolean bl = morningHalf = leaveRequest.getStartOnSelect() == 1;
        }
        while (!itDate.isEqual(leaveTo.plusDays(1L)) && !itDate.isEqual(toDate.plusDays(1L))) {
            daysToAdd = itDate.equals(leaveFrom) && !morningHalf ? BigDecimal.valueOf(this.computeStartDateWithSelect(itDate, leaveRequest.getStartOnSelect(), weeklyPlanning)) : (itDate.equals(leaveTo) && !eveningHalf ? BigDecimal.valueOf(this.computeEndDateWithSelect(itDate, leaveRequest.getEndOnSelect(), weeklyPlanning)) : BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, itDate)));
            if (!this.publicHolidayHrService.checkPublicHolidayDay(itDate, employee)) {
                leaveDays = leaveDays.add(daysToAdd);
            }
            itDate = itDate.plusDays(1L);
        }
        return leaveDays;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(LeaveRequest leaveRequest) throws AxelorException {
        if (leaveRequest.getLeaveLine().getLeaveReason().getManageAccumulation().booleanValue()) {
            this.manageCancelLeaves(leaveRequest);
        }
        if (leaveRequest.getIcalendarEvent() != null) {
            ICalendarEvent event = leaveRequest.getIcalendarEvent();
            leaveRequest.setIcalendarEvent(null);
            this.icalEventRepo.remove(this.icalEventRepo.find(event.getId()));
        }
        leaveRequest.setStatusSelect(5);
    }

    @Override
    public Message sendCancellationEmail(LeaveRequest leaveRequest) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(leaveRequest.getCompany());
        if (hrConfig.getLeaveMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)leaveRequest), this.hrConfigService.getCanceledLeaveTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirm(LeaveRequest leaveRequest) throws AxelorException {
        if (leaveRequest.getLeaveLine().getLeaveReason().getManageAccumulation().booleanValue()) {
            this.manageSentLeaves(leaveRequest);
        }
        leaveRequest.setStatusSelect(2);
        leaveRequest.setRequestDate(this.appBaseService.getTodayDate());
        this.leaveRequestRepo.save((Model)((Object)leaveRequest));
    }

    @Override
    public Message sendConfirmationEmail(LeaveRequest leaveRequest) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(leaveRequest.getCompany());
        if (hrConfig.getLeaveMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)leaveRequest), this.hrConfigService.getSentLeaveTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(LeaveRequest leaveRequest) throws AxelorException {
        LeaveLine leaveLine = leaveRequest.getLeaveLine();
        if (leaveLine.getLeaveReason().getManageAccumulation().booleanValue()) {
            this.manageValidateLeaves(leaveRequest);
        }
        leaveRequest.setStatusSelect(3);
        leaveRequest.setValidatedBy(AuthUtils.getUser());
        leaveRequest.setValidationDate(this.appBaseService.getTodayDate());
        leaveRequest.setQuantityBeforeValidation(leaveLine.getQuantity());
        this.leaveRequestRepo.save((Model)((Object)leaveRequest));
        this.createEvents(leaveRequest);
    }

    @Override
    public Message sendValidationEmail(LeaveRequest leaveRequest) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(leaveRequest.getCompany());
        if (hrConfig.getLeaveMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)leaveRequest), this.hrConfigService.getValidatedLeaveTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void refuse(LeaveRequest leaveRequest) throws AxelorException {
        if (leaveRequest.getLeaveLine().getLeaveReason().getManageAccumulation().booleanValue()) {
            this.manageRefuseLeaves(leaveRequest);
        }
        leaveRequest.setStatusSelect(4);
        leaveRequest.setRefusedBy(AuthUtils.getUser());
        leaveRequest.setRefusalDate(this.appBaseService.getTodayDate());
        this.leaveRequestRepo.save((Model)((Object)leaveRequest));
    }

    @Override
    public Message sendRefusalEmail(LeaveRequest leaveRequest) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(leaveRequest.getCompany());
        if (hrConfig.getLeaveMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)leaveRequest), this.hrConfigService.getRefusedLeaveTemplate(hrConfig));
        }
        return null;
    }

    @Override
    public boolean willHaveEnoughDays(LeaveRequest leaveRequest) {
        LocalDateTime todayDate = this.appBaseService.getTodayDateTime().toLocalDateTime();
        LocalDateTime beginDate = leaveRequest.getFromDateT();
        int interval = (beginDate.getYear() - todayDate.getYear()) * 12 + beginDate.getMonthValue() - todayDate.getMonthValue();
        BigDecimal num = leaveRequest.getLeaveLine().getQuantity().add(leaveRequest.getUser().getEmployee().getWeeklyPlanning().getLeaveCoef().multiply(leaveRequest.getLeaveLine().getLeaveReason().getDefaultDayNumberGain()).multiply(BigDecimal.valueOf(interval)));
        return leaveRequest.getDuration().compareTo(num) <= 0;
    }

    @Transactional
    public LeaveLine getLeaveReasonToJustify(Employee employee, LeaveReason leaveReason) {
        LeaveLine leaveLineBase = null;
        if (employee.getLeaveLineList() != null || !employee.getLeaveLineList().isEmpty()) {
            for (LeaveLine leaveLine : employee.getLeaveLineList()) {
                if (!leaveReason.equals((Object)leaveLine.getLeaveReason())) continue;
                leaveLineBase = leaveLine;
            }
        }
        return leaveLineBase;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public LeaveLine createLeaveReasonToJustify(Employee employee, LeaveReason leaveReason) throws AxelorException {
        LeaveLine leaveLineEmployee = new LeaveLine();
        leaveLineEmployee.setLeaveReason(leaveReason);
        leaveLineEmployee.setEmployee(employee);
        this.leaveLineRepo.save((Model)((Object)leaveLineEmployee));
        return leaveLineEmployee;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public LeaveLine addLeaveReasonOrCreateIt(Employee employee, LeaveReason leaveReason) throws AxelorException {
        LeaveLine leaveLine = this.getLeaveReasonToJustify(employee, leaveReason);
        if (leaveLine == null || leaveLine.getLeaveReason() != leaveReason) {
            leaveLine = this.createLeaveReasonToJustify(employee, leaveReason);
        }
        return leaveLine;
    }

    @Override
    public boolean isLeaveDay(User user, LocalDate date) {
        return this.getLeave(user, date) != null;
    }

    @Override
    public LeaveRequest getLeave(User user, LocalDate date) {
        List leaves = JPA.all(LeaveRequest.class).filter("self.user = :userId AND self.statusSelect IN (:awaitingValidation,:validated)").bind("userId", (Object)user).bind("awaitingValidation", (Object)2).bind("validated", (Object)3).fetch();
        if (ObjectUtils.notEmpty((Object)leaves)) {
            for (LeaveRequest leave : leaves) {
                LocalDate from = leave.getFromDateT().toLocalDate();
                LocalDate to = leave.getToDateT().toLocalDate();
                if ((!from.isBefore(date) || !to.isAfter(date)) && !from.isEqual(date) && !to.isEqual(date)) continue;
                return leave;
            }
        }
        return null;
    }
}

