/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.lunch.voucher;

import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LunchVoucherAdvance;
import com.axelor.apps.hr.db.repo.HRConfigRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherAdvanceRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherAdvanceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class LunchVoucherAdvanceServiceImpl
implements LunchVoucherAdvanceService {
    protected HRConfigService hrConfigService;

    @Inject
    public LunchVoucherAdvanceServiceImpl(HRConfigService hrConfigService) {
        this.hrConfigService = hrConfigService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void onNewAdvance(LunchVoucherAdvance lunchVoucherAdvance) throws AxelorException {
        HRConfig config = this.hrConfigService.getHRConfig(lunchVoucherAdvance.getEmployee().getMainEmploymentContract().getPayCompany());
        config.setAvailableStockLunchVoucher(config.getAvailableStockLunchVoucher() - lunchVoucherAdvance.getNbrLunchVouchers());
        ((LunchVoucherAdvanceRepository)((Object)Beans.get(LunchVoucherAdvanceRepository.class))).save((Model)((Object)lunchVoucherAdvance));
        ((HRConfigRepository)((Object)Beans.get(HRConfigRepository.class))).save((Model)((Object)config));
    }

    @Override
    public int useAdvance(LunchVoucherAdvance lunchVoucherAdvance, int qty) throws AxelorException {
        int toUse = lunchVoucherAdvance.getNbrLunchVouchers() - lunchVoucherAdvance.getNbrLunchVouchersUsed();
        if (qty > toUse) {
            lunchVoucherAdvance.setNbrLunchVouchersUsed(lunchVoucherAdvance.getNbrLunchVouchers());
            return qty - toUse;
        }
        lunchVoucherAdvance.setNbrLunchVouchersUsed(lunchVoucherAdvance.getNbrLunchVouchersUsed() + qty);
        return 0;
    }
}

