/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.lunch.voucher;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LunchVoucherAdvance;
import com.axelor.apps.hr.db.LunchVoucherMgt;
import com.axelor.apps.hr.db.LunchVoucherMgtLine;
import com.axelor.apps.hr.db.repo.LunchVoucherAdvanceRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtLineRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.employee.EmployeeService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherMgtLineService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.RoundingMode;
import java.util.List;

public class LunchVoucherMgtLineServiceImpl
implements LunchVoucherMgtLineService {
    @Inject
    protected EmployeeService employeeService;

    @Override
    public LunchVoucherMgtLine create(Employee employee, LunchVoucherMgt lunchVoucherMgt) throws AxelorException {
        LunchVoucherMgtLine lunchVoucherMgtLine = new LunchVoucherMgtLine();
        lunchVoucherMgtLine.setEmployee(employee);
        this.computeAllAttrs(employee, lunchVoucherMgt, lunchVoucherMgtLine);
        return lunchVoucherMgtLine;
    }

    @Override
    public void computeAllAttrs(Employee employee, LunchVoucherMgt lunchVoucherMgt, LunchVoucherMgtLine lunchVoucherMgtLine) {
        Integer lineStatus = LunchVoucherMgtLineRepository.STATUS_CALCULATED;
        try {
            lunchVoucherMgtLine.setInAdvanceNbr(this.computeEmployeeLunchVoucherAdvance(employee));
            lunchVoucherMgtLine.setDaysWorkedNbr(this.employeeService.getDaysWorkedInPeriod(employee, lunchVoucherMgt.getLeavePeriod().getFromDate(), lunchVoucherMgt.getLeavePeriod().getToDate()).setScale(0, RoundingMode.HALF_UP).intValue());
            this.compute(lunchVoucherMgtLine);
            this.fillLunchVoucherFormat(employee, lunchVoucherMgt, lunchVoucherMgtLine);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            lineStatus = LunchVoucherMgtLineRepository.STATUS_ANOMALY;
        }
        lunchVoucherMgtLine.setStatusSelect(lineStatus);
    }

    private Integer computeEmployeeLunchVoucherAdvance(Employee employee) {
        int number = 0;
        List list = ((LunchVoucherAdvanceRepository)((Object)Beans.get(LunchVoucherAdvanceRepository.class))).all().filter("self.employee.id = ?1 AND self.nbrLunchVouchersUsed < self.nbrLunchVouchers", new Object[]{employee.getId()}).fetch();
        for (LunchVoucherAdvance item : list) {
            number += item.getNbrLunchVouchers() - item.getNbrLunchVouchersUsed();
        }
        return number;
    }

    @Override
    public void fillLunchVoucherFormat(Employee employee, LunchVoucherMgt lunchVoucherMgt, LunchVoucherMgtLine lunchVoucherMgtLine) throws AxelorException {
        int employeeFormat = employee.getLunchVoucherFormatSelect();
        if (employeeFormat != 0) {
            lunchVoucherMgtLine.setLunchVoucherFormatSelect(employeeFormat);
        } else {
            Company company = lunchVoucherMgt.getCompany();
            HRConfig hrConfig = ((HRConfigService)Beans.get(HRConfigService.class)).getHRConfig(company);
            lunchVoucherMgtLine.setLunchVoucherFormatSelect(hrConfig.getLunchVoucherFormatSelect());
        }
    }

    @Override
    public void compute(LunchVoucherMgtLine lunchVoucherMgtLine) throws AxelorException {
        Integer lunchVoucherNumber = lunchVoucherMgtLine.getDaysWorkedNbr() - (lunchVoucherMgtLine.getCanteenEntries() + lunchVoucherMgtLine.getDaysOverseas() + lunchVoucherMgtLine.getInAdvanceNbr() + lunchVoucherMgtLine.getInvitation());
        lunchVoucherMgtLine.setLunchVoucherNumber(Integer.max(lunchVoucherNumber, 0));
    }
}

