/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.lunch.voucher;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LunchVoucherAdvance;
import com.axelor.apps.hr.db.LunchVoucherMgt;
import com.axelor.apps.hr.db.LunchVoucherMgtLine;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.HRConfigRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherAdvanceRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtLineRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherAdvanceService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherMgtLineService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherMgtService;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class LunchVoucherMgtServiceImpl
implements LunchVoucherMgtService {
    protected LunchVoucherMgtRepository lunchVoucherMgtRepository;
    protected LunchVoucherMgtLineService lunchVoucherMgtLineService;
    protected LunchVoucherAdvanceService lunchVoucherAdvanceService;
    protected HRConfigService hrConfigService;

    @Inject
    public LunchVoucherMgtServiceImpl(LunchVoucherMgtLineService lunchVoucherMgtLineService, LunchVoucherAdvanceService lunchVoucherAdvanceService, LunchVoucherMgtRepository lunchVoucherMgtRepository, HRConfigService hrConfigService) {
        this.lunchVoucherMgtLineService = lunchVoucherMgtLineService;
        this.lunchVoucherMgtRepository = lunchVoucherMgtRepository;
        this.lunchVoucherAdvanceService = lunchVoucherAdvanceService;
        this.hrConfigService = hrConfigService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void calculate(LunchVoucherMgt lunchVoucherMgt) throws AxelorException {
        Company company = lunchVoucherMgt.getCompany();
        if (company == null) {
            throw new AxelorException((Model)((Object)lunchVoucherMgt), 1, I18n.get((String)"Please fill a company."));
        }
        if (lunchVoucherMgt.getLeavePeriod() == null) {
            throw new AxelorException((Model)((Object)lunchVoucherMgt), 1, I18n.get((String)"Please fill a leave period."));
        }
        HRConfig hrConfig = this.hrConfigService.getHRConfig(company);
        List employeeList = ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.mainEmploymentContract.payCompany = ?1", new Object[]{company}).fetch();
        for (Employee employee : employeeList) {
            if (employee == null) continue;
            LunchVoucherMgtLine lunchVoucherMgtLine = this.obtainLineFromEmployee(employee, lunchVoucherMgt);
            if (lunchVoucherMgtLine == null) {
                lunchVoucherMgtLine = this.lunchVoucherMgtLineService.create(employee, lunchVoucherMgt);
                lunchVoucherMgt.addLunchVoucherMgtLineListItem(lunchVoucherMgtLine);
                continue;
            }
            if (lunchVoucherMgtLine.getStatusSelect() == LunchVoucherMgtLineRepository.STATUS_CALCULATED) continue;
            this.lunchVoucherMgtLineService.computeAllAttrs(employee, lunchVoucherMgt, lunchVoucherMgtLine);
        }
        lunchVoucherMgt.setStatusSelect(LunchVoucherMgtRepository.STATUS_CALCULATED);
        lunchVoucherMgt.setStockQuantityStatus(hrConfig.getAvailableStockLunchVoucher());
        this.calculateTotal(lunchVoucherMgt);
        this.lunchVoucherMgtRepository.save((Model)((Object)lunchVoucherMgt));
    }

    protected LunchVoucherMgtLine obtainLineFromEmployee(Employee employee, LunchVoucherMgt lunchVoucherMgt) {
        for (LunchVoucherMgtLine line : lunchVoucherMgt.getLunchVoucherMgtLineList()) {
            if (line.getEmployee() != employee) continue;
            return line;
        }
        return null;
    }

    @Override
    public void calculateTotal(LunchVoucherMgt lunchVoucherMgt) {
        List<LunchVoucherMgtLine> lunchVoucherMgtLineList = lunchVoucherMgt.getLunchVoucherMgtLineList();
        int total = 0;
        int totalInAdvance = 0;
        int totalGiven = 0;
        if (!ObjectUtils.isEmpty(lunchVoucherMgtLineList)) {
            for (LunchVoucherMgtLine lunchVoucherMgtLine : lunchVoucherMgtLineList) {
                total += lunchVoucherMgtLine.getLunchVoucherNumber().intValue();
                totalInAdvance += lunchVoucherMgtLine.getInAdvanceNbr().intValue();
                totalGiven += lunchVoucherMgtLine.getGivenToEmployee().intValue();
            }
        }
        lunchVoucherMgt.setTotalLunchVouchers(total + totalInAdvance + lunchVoucherMgt.getStockLineQuantity());
        lunchVoucherMgt.setRequestedLunchVouchers(total + lunchVoucherMgt.getStockLineQuantity());
        lunchVoucherMgt.setGivenLunchVouchers(totalGiven);
    }

    @Override
    public int checkStock(Company company, int numberToUse) throws AxelorException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(company);
        int minStoclLV = hrConfig.getMinStockLunchVoucher();
        int availableStoclLV = hrConfig.getAvailableStockLunchVoucher();
        return availableStoclLV - numberToUse - minStoclLV;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public int updateStock(List<LunchVoucherMgtLine> newLunchVoucherMgtLines, List<LunchVoucherMgtLine> oldLunchVoucherMgtLines, Company company) throws AxelorException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(company);
        int newLunchVoucherQty = hrConfig.getAvailableStockLunchVoucher();
        int i = 0;
        for (LunchVoucherMgtLine line : newLunchVoucherMgtLines) {
            int oldQty = oldLunchVoucherMgtLines.get(i).getGivenToEmployee();
            int newQty = line.getGivenToEmployee();
            newLunchVoucherQty = newLunchVoucherQty - newQty + oldQty;
            ++i;
        }
        hrConfig.setAvailableStockLunchVoucher(newLunchVoucherQty);
        ((HRConfigRepository)((Object)Beans.get(HRConfigRepository.class))).save((Model)((Object)hrConfig));
        return hrConfig.getAvailableStockLunchVoucher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackOn={Exception.class})
    public void export(LunchVoucherMgt lunchVoucherMgt) throws IOException {
        MetaFile metaFile = new MetaFile();
        metaFile.setFileName(I18n.get((String)"LunchVoucherCommand") + " - " + LocalDate.now().format(DateTimeFormatter.ISO_DATE) + ".csv");
        Path tempFile = MetaFiles.createTempFile(null, (String)".csv", (FileAttribute[])new FileAttribute[0]);
        FileOutputStream os = new FileOutputStream(tempFile.toFile());
        try (OutputStreamWriter writer = new OutputStreamWriter(os);){
            ArrayList<String> header = new ArrayList<String>();
            header.add(this.escapeCsv(I18n.get((String)"Company code")));
            header.add(this.escapeCsv(I18n.get((String)"Lunch Voucher's number")));
            header.add(this.escapeCsv(I18n.get((String)"Employee")));
            header.add(this.escapeCsv(I18n.get((String)"Lunch Voucher format")));
            writer.write(Joiner.on((String)";").join(header));
            for (LunchVoucherMgtLine lunchVoucherMgtLine : lunchVoucherMgt.getLunchVoucherMgtLineList()) {
                ArrayList<String> line = new ArrayList<String>();
                line.add(this.escapeCsv(lunchVoucherMgt.getCompany().getCode()));
                line.add(this.escapeCsv(lunchVoucherMgtLine.getLunchVoucherNumber().toString()));
                line.add(this.escapeCsv(lunchVoucherMgtLine.getEmployee().getName()));
                line.add(this.escapeCsv(lunchVoucherMgtLine.getEmployee().getLunchVoucherFormatSelect().toString()));
                writer.write("\n");
                writer.write(Joiner.on((String)";").join(line));
            }
            ((MetaFiles)Beans.get(MetaFiles.class)).upload(tempFile.toFile(), metaFile);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
        lunchVoucherMgt.setCsvFile(metaFile);
        lunchVoucherMgt.setExportDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
        this.lunchVoucherMgtRepository.save((Model)((Object)lunchVoucherMgt));
    }

    protected String escapeCsv(String value) {
        if (value == null) {
            return "";
        }
        if (value.indexOf(34) > -1) {
            value = value.replaceAll("\"", "\"\"");
        }
        return '\"' + value + '\"';
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(LunchVoucherMgt lunchVoucherMgt) throws AxelorException {
        Company company = lunchVoucherMgt.getCompany();
        HRConfig hrConfig = this.hrConfigService.getHRConfig(company);
        LunchVoucherAdvanceRepository advanceRepo = (LunchVoucherAdvanceRepository)((Object)Beans.get(LunchVoucherAdvanceRepository.class));
        block0: for (LunchVoucherMgtLine item : lunchVoucherMgt.getLunchVoucherMgtLineList()) {
            if (item.getInAdvanceNbr() <= 0) continue;
            int qtyToUse = item.getInAdvanceNbr();
            List list = advanceRepo.all().filter("self.employee.id = ?1 AND self.nbrLunchVouchersUsed < self.nbrLunchVouchers", new Object[]{item.getEmployee().getId()}).order("distributionDate").fetch();
            for (LunchVoucherAdvance subItem : list) {
                qtyToUse = this.lunchVoucherAdvanceService.useAdvance(subItem, qtyToUse);
                advanceRepo.save((Model)((Object)subItem));
                if (qtyToUse > 0) continue;
                continue block0;
            }
        }
        hrConfig.setAvailableStockLunchVoucher(hrConfig.getAvailableStockLunchVoucher() + lunchVoucherMgt.getStockLineQuantity());
        lunchVoucherMgt.setStatusSelect(LunchVoucherMgtRepository.STATUS_VALIDATED);
        ((HRConfigRepository)((Object)Beans.get(HRConfigRepository.class))).save((Model)((Object)hrConfig));
        this.lunchVoucherMgtRepository.save((Model)((Object)lunchVoucherMgt));
    }
}

