/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.timesheet;

import com.axelor.apps.base.db.DayPlanning;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.service.publicHoliday.PublicHolidayService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.TimesheetReminder;
import com.axelor.apps.hr.db.TimesheetReminderLine;
import com.axelor.apps.hr.db.TimesheetReport;
import com.axelor.apps.hr.db.repo.ExtraHoursLineRepository;
import com.axelor.apps.hr.db.repo.ExtraHoursRepository;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.db.repo.TimesheetReminderRepository;
import com.axelor.apps.hr.db.repo.TimesheetReportRepository;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.employee.EmployeeService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetReportService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class TimesheetReportServiceImpl
implements TimesheetReportService {
    protected TimesheetReminderRepository timesheetReminderRepo;
    protected TimesheetReportRepository timesheetReportRepository;
    protected ExtraHoursLineRepository extraHoursLineRepository;
    protected TimesheetLineRepository timesheetLineRepository;
    protected MessageService messageService;
    protected TemplateMessageService templateMessageService;
    protected PublicHolidayService publicHolidayService;
    protected WeeklyPlanningService weeklyPlanningService;
    protected EmployeeService employeeService;
    protected TimesheetLineService timesheetLineService;
    protected LeaveService leaveService;

    @Inject
    public TimesheetReportServiceImpl(TimesheetReminderRepository timesheetReminderRepo, TimesheetReportRepository timesheetReportRepository, ExtraHoursLineRepository extraHoursLineRepository, TimesheetLineRepository timesheetLineRepository, MessageService messageService, TemplateMessageService templateMessageService, PublicHolidayService publicHolidayService, WeeklyPlanningService weeklyPlanningService, EmployeeService employeeService, TimesheetLineService timesheetLineService, LeaveService leaveService) {
        this.timesheetReminderRepo = timesheetReminderRepo;
        this.timesheetReportRepository = timesheetReportRepository;
        this.extraHoursLineRepository = extraHoursLineRepository;
        this.timesheetLineRepository = timesheetLineRepository;
        this.messageService = messageService;
        this.templateMessageService = templateMessageService;
        this.publicHolidayService = publicHolidayService;
        this.weeklyPlanningService = weeklyPlanningService;
        this.employeeService = employeeService;
        this.timesheetLineService = timesheetLineService;
        this.leaveService = leaveService;
    }

    @Override
    public Set<User> getUserToBeReminded(TimesheetReport timesheetReport) {
        HashSet<User> userSet = new HashSet<User>();
        BigDecimal worksHour = BigDecimal.ZERO;
        BigDecimal workedHour = BigDecimal.ZERO;
        List<User> users = this.getUsers(timesheetReport);
        LocalDate fromDate = timesheetReport.getFromDate();
        LocalDate toDate = timesheetReport.getToDate();
        for (User user : users) {
            Employee employee = user.getEmployee();
            try {
                worksHour = workedHour = BigDecimal.ZERO;
                BigDecimal publicHolidays = this.publicHolidayService.computePublicHolidayDays(fromDate, toDate, employee.getWeeklyPlanning(), employee.getPublicHolidayEventsPlanning());
                worksHour = this.getTotalWeekWorksHours(user, fromDate, toDate, publicHolidays);
                if (worksHour.compareTo(workedHour = this.getTotalWeekWorkedHours(user, fromDate, toDate, publicHolidays)) == 0) continue;
                userSet.add(user);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        return userSet;
    }

    @Override
    @Transactional
    public List<Message> sendReminders(TimesheetReport timesheetReport) throws AxelorException {
        Template reminderTemplate = ((AppHumanResourceService)Beans.get(AppHumanResourceService.class)).getAppTimesheet().getTimesheetReminderTemplate();
        if (reminderTemplate == null) {
            throw new AxelorException(3, I18n.get((String)"Please configure the template for email reminder"));
        }
        List<TimesheetReminder> timesheetReminders = this.getTimesheetReminderList(timesheetReport);
        return this.sendEmailMessage(timesheetReminders, reminderTemplate);
    }

    private List<TimesheetReminder> getTimesheetReminderList(TimesheetReport timesheetReport) {
        ArrayList<TimesheetReminder> timesheetReminders = new ArrayList<TimesheetReminder>();
        ArrayList<User> users = new ArrayList<User>(timesheetReport.getReminderUserSet());
        try {
            this.addTimesheetReminder(timesheetReport, users, timesheetReminders);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return timesheetReminders;
    }

    private void addTimesheetReminder(TimesheetReport timesheetReport, List<User> users, List<TimesheetReminder> timesheetReminders) throws AxelorException {
        BigDecimal worksHour = BigDecimal.ZERO;
        BigDecimal workedHour = BigDecimal.ZERO;
        BigDecimal missingHour = BigDecimal.ZERO;
        BigDecimal extraHour = BigDecimal.ZERO;
        LocalDate fromDate = timesheetReport.getFromDate();
        LocalDate toDate = null;
        do {
            if ((toDate = fromDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY))).until(timesheetReport.getToDate()).getDays() < 0) {
                toDate = timesheetReport.getToDate();
            }
            for (User user : users) {
                Employee employee = user.getEmployee();
                missingHour = BigDecimal.ZERO;
                extraHour = BigDecimal.ZERO;
                BigDecimal publicHolidays = this.publicHolidayService.computePublicHolidayDays(fromDate, toDate, employee.getWeeklyPlanning(), employee.getPublicHolidayEventsPlanning());
                worksHour = this.getTotalWeekWorksHours(user, fromDate, toDate, publicHolidays);
                if (worksHour.compareTo(workedHour = this.getTotalWeekWorkedHours(user, fromDate, toDate, publicHolidays)) == 1) {
                    missingHour = worksHour.subtract(workedHour);
                } else if (worksHour.compareTo(workedHour) == -1) {
                    extraHour = workedHour.subtract(worksHour);
                }
                if (missingHour.compareTo(BigDecimal.ZERO) == 0 && extraHour.compareTo(BigDecimal.ZERO) == 0) continue;
                Optional<TimesheetReminder> optReminder = timesheetReminders.stream().filter(reminder -> reminder.getEmployee().getId().compareTo(employee.getId()) == 0).findFirst();
                TimesheetReminder timesheetReminder = null;
                if (optReminder.isPresent()) {
                    timesheetReminder = optReminder.get();
                    timesheetReminder.addTimesheetReminderLineListItem(this.createTimesheetReminderLine(fromDate, toDate, worksHour, missingHour, extraHour));
                } else {
                    ArrayList<TimesheetReminderLine> timesheetReminderLines = new ArrayList<TimesheetReminderLine>();
                    timesheetReminder = new TimesheetReminder();
                    timesheetReminder.setEmployee(employee);
                    timesheetReminder.setTimesheetReminderLineList(timesheetReminderLines);
                    timesheetReminder.addTimesheetReminderLineListItem(this.createTimesheetReminderLine(fromDate, toDate, worksHour, missingHour, extraHour));
                    timesheetReminders.add(timesheetReminder);
                }
                this.timesheetReminderRepo.save((Model)((Object)timesheetReminder));
            }
            fromDate = fromDate.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
        } while (toDate.until(timesheetReport.getToDate()).getDays() > 0);
    }

    private List<Message> sendEmailMessage(List<TimesheetReminder> timesheetReminders, Template reminderTemplate) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (TimesheetReminder timesheetReminder : timesheetReminders) {
            try {
                Message message = this.templateMessageService.generateMessage((Model)((Object)timesheetReminder), reminderTemplate);
                message = this.messageService.sendMessage(message);
                timesheetReminder.setEmailSentDateT(LocalDateTime.now());
                messages.add(message);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        return messages;
    }

    private TimesheetReminderLine createTimesheetReminderLine(LocalDate fromDate, LocalDate toDate, BigDecimal worksHour, BigDecimal missingHour, BigDecimal extraHour) {
        TimesheetReminderLine line = new TimesheetReminderLine();
        line.setFromDate(fromDate);
        line.setToDate(toDate);
        line.setRequiredHours(worksHour);
        line.setExtraHours(extraHour);
        line.setMissingHours(missingHour);
        line.setWorkHour(worksHour.subtract(missingHour).add(extraHour));
        return line;
    }

    @Override
    public List<Map<String, Object>> getTimesheetReportList(String timesheetReportId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 5);
        TimesheetReport timesheetReport = (TimesheetReport)((Object)this.timesheetReportRepository.find(Long.parseLong(timesheetReportId.toString())));
        int numOfDays = timesheetReport.getFromDate().until(timesheetReport.getToDate()).getDays();
        List daysRange = Stream.iterate(timesheetReport.getFromDate(), date -> date.plusDays(1L)).limit(numOfDays + 1).collect(Collectors.toList());
        List<User> users = this.getUsers(timesheetReport);
        for (User user : users) {
            Employee employee = user.getEmployee();
            BigDecimal dailyWorkingHours = employee.getDailyWorkHours();
            WeeklyPlanning weeklyPlanning = employee.getWeeklyPlanning();
            Integer weekNumber = 1;
            int lastDayIndex = -1;
            int daysInWeek = 0;
            try {
                for (LocalDate date2 : daysRange) {
                    DayPlanning dayPlanning = this.weeklyPlanningService.findDayPlanning(weeklyPlanning, date2);
                    if (dayPlanning == null) continue;
                    int dayIndex = date2.get(weekFields.dayOfWeek()) - 1;
                    if (lastDayIndex < dayIndex) {
                        lastDayIndex = dayIndex;
                        if (this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, date2) != 0.0) {
                            ++daysInWeek;
                        }
                    } else {
                        lastDayIndex = -1;
                        daysInWeek = 1;
                        Integer n = weekNumber;
                        Integer n2 = weekNumber = Integer.valueOf(weekNumber + 1);
                    }
                    BigDecimal weeklyWorkHours = daysInWeek <= 5 ? employee.getWeeklyWorkHours().multiply(BigDecimal.valueOf((double)daysInWeek / 5.0)).setScale(2, RoundingMode.HALF_EVEN) : employee.getWeeklyWorkHours();
                    Map<String, Object> map = this.getTimesheetMap(user, date2, dailyWorkingHours);
                    map.put("weeklyWorkHours", weeklyWorkHours);
                    map.put("weekNumber", weekNumber.toString());
                    list.add(map);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return list;
    }

    private Map<String, Object> getTimesheetMap(User user, LocalDate date, BigDecimal dailyWorkingHours) throws AxelorException {
        Employee employee = user.getEmployee();
        BigDecimal worksHour = BigDecimal.ZERO;
        BigDecimal workedHour = BigDecimal.ZERO;
        boolean isPublicHoliday = this.publicHolidayService.checkPublicHolidayDay(date, employee.getPublicHolidayEventsPlanning());
        worksHour = this.getTotalWorksHours(user, date, isPublicHoliday, dailyWorkingHours);
        try {
            workedHour = this.getTotalWorkedHours(user, date, isPublicHoliday, dailyWorkingHours);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userName", user.getFullName());
        map.put("date", DateTool.toDate((LocalDate)date));
        map.put("workedHour", workedHour);
        map.put("workingHour", worksHour);
        return map;
    }

    private BigDecimal getTotalWorksHours(User user, LocalDate date, boolean isPublicHoliday, BigDecimal dailyWorkingHours) throws AxelorException {
        Employee employee = user.getEmployee();
        BigDecimal worksHour = this.employeeService.getDaysWorksInPeriod(employee, date, date).multiply(employee.getDailyWorkHours()).setScale(2, RoundingMode.HALF_EVEN);
        if (isPublicHoliday) {
            worksHour = worksHour.add(dailyWorkingHours);
        }
        double extraHours = this.extraHoursLineRepository.all().filter("self.user = ? AND self.date = ? AND (self.extraHours.statusSelect = ? OR self.extraHours.statusSelect = ?)", new Object[]{user, date, ExtraHoursRepository.STATUS_VALIDATED, ExtraHoursRepository.STATUS_CONFIRMED}).fetchStream().mapToDouble(ehl -> Double.parseDouble(ehl.getQty().toString())).sum();
        worksHour = worksHour.add(new BigDecimal(extraHours));
        return worksHour.setScale(2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getTotalWeekWorksHours(User user, LocalDate fromDate, LocalDate toDate, BigDecimal publicHolidays) throws AxelorException {
        Employee employee = user.getEmployee();
        BigDecimal worksHour = this.employeeService.getDaysWorksInPeriod(employee, fromDate, toDate).multiply(employee.getDailyWorkHours()).setScale(2, RoundingMode.HALF_EVEN);
        worksHour = worksHour.add(publicHolidays.multiply(employee.getDailyWorkHours()));
        double extraHours = this.extraHoursLineRepository.all().filter("self.user = ? AND (self.date BETWEEN ? AND ?) AND (self.extraHours.statusSelect = ? OR self.extraHours.statusSelect = ?)", new Object[]{user, fromDate, toDate, ExtraHoursRepository.STATUS_VALIDATED, ExtraHoursRepository.STATUS_CONFIRMED}).fetchStream().mapToDouble(ehl -> Double.parseDouble(ehl.getQty().toString())).sum();
        worksHour = worksHour.add(new BigDecimal(extraHours));
        return worksHour.setScale(2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getTotalWorkedHours(User user, LocalDate date, boolean isPublicHoliday, BigDecimal dailyWorkingHours) throws AxelorException {
        BigDecimal totalHours = BigDecimal.ZERO;
        List timesheetLineList = this.timesheetLineRepository.all().filter("self.user = ? AND self.date = ? AND (self.timesheet.statusSelect = ? OR self.timesheet.statusSelect = ?)", new Object[]{user, date, 2, 3}).fetch();
        Duration totalDuration = this.timesheetLineService.computeTotalDuration(timesheetLineList);
        totalHours = new BigDecimal(totalDuration.getSeconds()).divide(BigDecimal.valueOf(3600L)).setScale(2, RoundingMode.HALF_EVEN);
        totalHours = isPublicHoliday ? totalHours.add(dailyWorkingHours) : totalHours.add(this.getLeaveHours(user, date, dailyWorkingHours));
        return totalHours.setScale(2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getTotalWeekWorkedHours(User user, LocalDate fromDate, LocalDate toDate, BigDecimal publicHolidays) throws AxelorException {
        BigDecimal totalHours = BigDecimal.ZERO;
        Employee employee = user.getEmployee();
        List timesheetLineList = this.timesheetLineRepository.all().filter("self.user = ? AND (self.date BETWEEN ? AND ?) AND (self.timesheet.statusSelect = ? OR self.timesheet.statusSelect = ?)", new Object[]{user, fromDate, toDate, 3, 2}).fetch();
        Duration totalDuration = this.timesheetLineService.computeTotalDuration(timesheetLineList);
        totalHours = new BigDecimal(totalDuration.getSeconds()).divide(BigDecimal.valueOf(3600L)).setScale(2, RoundingMode.HALF_EVEN);
        totalHours = totalHours.add(publicHolidays.multiply(employee.getDailyWorkHours()));
        totalHours = totalHours.add(this.getWeekLeaveHours(user, fromDate, toDate, employee.getDailyWorkHours()));
        return totalHours.setScale(2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getLeaveHours(User user, LocalDate date, BigDecimal dailyWorkingHours) throws AxelorException {
        LeaveRequest leave = this.leaveService.getLeave(user, date);
        if (leave != null) {
            return this.leaveService.computeDuration(leave, date, date).multiply(dailyWorkingHours);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getWeekLeaveHours(User user, LocalDate fromDate, LocalDate toDate, BigDecimal dailyWorkingHours) throws AxelorException {
        BigDecimal leaveHours = BigDecimal.ZERO;
        do {
            boolean isPublicHoliday;
            LeaveRequest leave;
            if ((leave = this.leaveService.getLeave(user, fromDate)) == null || (isPublicHoliday = this.publicHolidayService.checkPublicHolidayDay(fromDate, user.getEmployee().getPublicHolidayEventsPlanning()))) continue;
            leaveHours = leaveHours.add(this.leaveService.computeDuration(leave, fromDate, fromDate).multiply(dailyWorkingHours));
        } while ((fromDate = fromDate.plusDays(1L)).until(toDate).getDays() > -1);
        return leaveHours;
    }

    protected List<User> getUsers(TimesheetReport timesheetReport) {
        QueryBuilder userQuery = QueryBuilder.of(User.class);
        userQuery.add("self.employee IS NOT NULL AND self.employee.weeklyPlanning IS NOT NULL AND self.employee.publicHolidayEventsPlanning IS NOT NULL AND self.employee.mainEmploymentContract IS NOT NULL");
        if (!CollectionUtils.isEmpty(timesheetReport.getUserSet())) {
            userQuery.add("self IN :users");
            userQuery.bind("users", timesheetReport.getUserSet());
        }
        return userQuery.build().fetch();
    }
}

