/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.user;

import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.AppLeave;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class UserHrServiceImpl
implements UserHrService {
    @Inject
    UserRepository userRepo;
    @Inject
    private AppHumanResourceService appHumanResourceService;

    @Override
    @Transactional
    public void createEmployee(User user) {
        HRConfig hrConfig;
        if (user.getPartner() == null) {
            ((UserService)Beans.get(UserService.class)).createPartner(user);
        }
        AppBase appBase = this.appHumanResourceService.getAppBase();
        AppLeave appLeave = this.appHumanResourceService.getAppLeave();
        Employee employee = new Employee();
        employee.setContactPartner(user.getPartner());
        employee.setTimeLoggingPreferenceSelect(appBase.getTimeLoggingPreferenceSelect());
        employee.setDailyWorkHours(appBase.getDailyWorkHours());
        employee.setNegativeValueLeave(appLeave.getAllowNegativeLeaveEmployees());
        EventsPlanning planning = null;
        Company company = user.getActiveCompany();
        if (company != null && (hrConfig = company.getHrConfig()) != null) {
            planning = hrConfig.getPublicHolidayEventsPlanning();
        }
        employee.setPublicHolidayEventsPlanning(planning);
        employee.setUser(user);
        ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).save((Model)((Object)employee));
        user.setEmployee(employee);
        this.userRepo.save((Model)((Object)user));
    }

    @Override
    @Transactional
    public Company getPayCompany(User user) {
        Company payCompany = null;
        if (user.getEmployee() != null && user.getEmployee().getMainEmploymentContract() != null && user.getEmployee().getMainEmploymentContract().getPayCompany() != null) {
            payCompany = user.getEmployee().getMainEmploymentContract().getPayCompany();
        } else if (user.getActiveCompany() != null) {
            payCompany = user.getActiveCompany();
        }
        return payCompany;
    }

    @Override
    public Product getTimesheetProduct(User user) {
        if (user == null || user.getId() == null || user.getActiveCompany() == null) {
            return null;
        }
        user = (User)((Object)this.userRepo.find(user.getId()));
        Product product = null;
        HRConfig hrConfig = user.getActiveCompany().getHrConfig();
        if (hrConfig != null && hrConfig.getUseUniqueProductForTimesheet().booleanValue()) {
            product = hrConfig.getUniqueTimesheetProduct();
        }
        if (product == null && user.getEmployee() != null) {
            product = user.getEmployee().getProduct();
        }
        return product;
    }
}

