/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.hr.db.DPAE;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.service.employee.EmployeeService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.json.JSONException;
import wslite.json.JSONObject;

@Singleton
public class EmployeeController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void showAnnualReport(ActionRequest request, ActionResponse response) throws JSONException, NumberFormatException, AxelorException {
        String employeeId = request.getContext().get((Object)"_id").toString();
        String year = request.getContext().get((Object)"year").toString();
        int yearId = new JSONObject(year).getInt("id");
        String yearName = new JSONObject(year).getString("name");
        User user = AuthUtils.getUser();
        String name = I18n.get((String)"Annual expenses report") + " :  " + user.getFullName() + " (" + yearName + ")";
        String fileLink = ReportFactory.createReport((String)"EmployeeAnnualReport.rptdesign", (String)name).addParam("EmployeeId", (Object)Long.valueOf(employeeId)).addParam("YearId", (Object)yearId).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach(((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).find(Long.valueOf(employeeId))).generate().getFileLink();
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
        response.setCanClose(true);
    }

    public void setEmployeeSocialNetworkUrl(ActionRequest request, ActionResponse response) {
        Employee employee = (Employee)((Object)request.getContext().asType(Employee.class));
        if (employee.getContactPartner() != null) {
            Map<String, String> urlMap = ((EmployeeService)Beans.get(EmployeeService.class)).getSocialNetworkUrl(employee.getContactPartner().getName(), employee.getContactPartner().getFirstName());
            response.setAttr("contactPartner.facebookLabel", "title", (Object)urlMap.get("facebook"));
            response.setAttr("contactPartner.twitterLabel", "title", (Object)urlMap.get("twitter"));
            response.setAttr("contactPartner.linkedinLabel", "title", (Object)urlMap.get("linkedin"));
            response.setAttr("contactPartner.youtubeLabel", "title", (Object)urlMap.get("youtube"));
        }
    }

    public void setContactSocialNetworkUrl(ActionRequest request, ActionResponse response) {
        Partner partnerContact = (Partner)((Object)request.getContext().asType(Partner.class));
        Map<String, String> urlMap = ((EmployeeService)Beans.get(EmployeeService.class)).getSocialNetworkUrl(partnerContact.getName(), partnerContact.getFirstName());
        response.setAttr("facebookLabel", "title", (Object)urlMap.get("facebook"));
        response.setAttr("twitterLabel", "title", (Object)urlMap.get("twitter"));
        response.setAttr("linkedinLabel", "title", (Object)urlMap.get("linkedin"));
        response.setAttr("youtubeLabel", "title", (Object)urlMap.get("youtube"));
    }

    public void printEmployeePhonebook(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        String name = I18n.get((String)"Employee PhoneBook");
        String fileLink = ReportFactory.createReport((String)"EmployeePhoneBook.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("UserId", (Object)user.getId()).generate().getFileLink();
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void generateNewDPAE(ActionRequest request, ActionResponse response) {
        Employee employee = (Employee)((Object)request.getContext().asType(Employee.class));
        employee = (Employee)((Object)((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).find(employee.getId()));
        try {
            Long dpaeId = ((EmployeeService)Beans.get(EmployeeService.class)).generateNewDPAE(employee);
            ActionView.ActionViewBuilder builder = ActionView.define((String)I18n.get((String)"DPAE")).model(DPAE.class.getName()).add("grid", "dpae-grid").add("form", "dpae-form").context("_showRecord", (Object)dpaeId);
            response.setView(builder.map());
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }
}

