/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.expense;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.message.MessageServiceBaseImpl;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.ExtraHours;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.service.HRMenuTagService;
import com.axelor.apps.hr.service.HRMenuValidateService;
import com.axelor.apps.hr.service.KilometricService;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.StringTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExpenseController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        ExpenseLine expenseLine = (ExpenseLine)((Object)request.getContext().asType(ExpenseLine.class));
        expenseLine = ((ExpenseService)Beans.get(ExpenseService.class)).createAnalyticDistributionWithTemplate(expenseLine);
        response.setValue("analyticMoveLineList", expenseLine.getAnalyticMoveLineList());
    }

    public void computeAnalyticDistribution(ActionRequest request, ActionResponse response) throws AxelorException {
        ExpenseLine expenseLine = (ExpenseLine)((Object)request.getContext().asType(ExpenseLine.class));
        Expense expense = expenseLine.getExpense();
        if (expense == null) {
            this.setExpense(request, expenseLine);
        }
        if (((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getManageAnalyticAccounting().booleanValue()) {
            expenseLine = ((ExpenseService)Beans.get(ExpenseService.class)).computeAnalyticDistribution(expenseLine);
            response.setValue("analyticMoveLineList", expenseLine.getAnalyticMoveLineList());
        }
    }

    public void editExpense(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Company activeCompany = user.getActiveCompany();
        List expenseList = ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.user = ?1 AND self.company = ?2 AND self.statusSelect = 1 AND (self.multipleUsers is false OR self.multipleUsers is null)", new Object[]{user, activeCompany}).fetch();
        if (expenseList.isEmpty()) {
            response.setView(ActionView.define((String)I18n.get((String)"Expense")).model(Expense.class.getName()).add("form", "expense-form").context("_payCompany", (Object)((UserHrService)Beans.get(UserHrService.class)).getPayCompany(user)).map());
        } else if (expenseList.size() == 1) {
            response.setView(ActionView.define((String)I18n.get((String)"Expense")).model(Expense.class.getName()).add("form", "expense-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(((Expense)((Object)expenseList.get(0))).getId())).map());
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Expense")).model(Wizard.class.getName()).add("form", "popup-expense-form").param("forceEdit", "true").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("forceEdit", "true").param("popup-save", "false").map());
        }
    }

    public void editExpenseSelected(ActionRequest request, ActionResponse response) {
        Map expenseMap = (Map)request.getContext().get((Object)"expenseSelect");
        if (expenseMap == null) {
            response.setError(I18n.get((String)"Please, select an expense"));
            return;
        }
        Long expenseId = (long)((Integer)expenseMap.get("id"));
        response.setCanClose(true);
        response.setView(ActionView.define((String)I18n.get((String)"Expense")).model(Expense.class.getName()).add("form", "expense-form").param("forceEdit", "true").domain("self.id = " + expenseId).context("_showRecord", (Object)expenseId).map());
    }

    public void validateExpense(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Expenses to Validate")).model(Expense.class.getName()).add("grid", "expense-validate-grid").add("form", "expense-form");
        ((HRMenuValidateService)Beans.get(HRMenuValidateService.class)).createValidateDomain(user, employee, actionView);
        response.setView(actionView.map());
    }

    public void historicExpense(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Historic colleague Expenses")).model(Expense.class.getName()).add("grid", "expense-grid").add("form", "expense-form");
        actionView.domain("self.company = :_activeCompany AND (self.statusSelect = 3 OR self.statusSelect = 4)").context("_activeCompany", (Object)user.getActiveCompany());
        if (employee == null || !employee.getHrManager().booleanValue()) {
            actionView.domain(actionView.get().getDomain() + " AND self.user.employee.managerUser = :_user").context("_user", (Object)user);
        }
        response.setView(actionView.map());
    }

    public void showSubordinateExpenses(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Company activeCompany = user.getActiveCompany();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Expenses to be Validated by your subordinates")).model(Expense.class.getName()).add("grid", "expense-grid").add("form", "expense-form");
        String domain = "self.user.employee.managerUser.employee.managerUser = :_user AND self.company = :_activeCompany AND self.statusSelect = 2";
        long nbExpenses = Query.of(ExtraHours.class).filter(domain).bind("_user", (Object)user).bind("_activeCompany", (Object)activeCompany).count();
        if (nbExpenses == 0L) {
            response.setNotify(I18n.get((String)"No expense to be validated by your subordinates"));
        } else {
            response.setView(actionView.domain(domain).context("_user", (Object)user).context("_activeCompany", (Object)activeCompany).map());
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        expense = ((ExpenseService)Beans.get(ExpenseService.class)).compute(expense);
        response.setValues((Object)expense);
    }

    public void updateMoveDateAndPeriod(ActionRequest request, ActionResponse response) {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        expense = ((ExpenseService)Beans.get(ExpenseService.class)).updateMoveDateAndPeriod(expense);
        response.setValue("moveDate", (Object)expense.getMoveDate());
        response.setValue("period", (Object)expense.getPeriod());
    }

    public void ventilate(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
            expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
            Move move = ((ExpenseService)Beans.get(ExpenseService.class)).ventilate(expense);
            response.setReload(true);
            if (move != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Move")).model(Move.class.getName()).add("grid", "move-grid").add("form", "move-form").context("_showRecord", (Object)String.valueOf(move.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printExpense(ActionRequest request, ActionResponse response) throws AxelorException {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        String name = I18n.get((String)"Expense") + " " + expense.getFullName().replace("/", "-");
        String fileLink = ReportFactory.createReport((String)"Expense.rptdesign", (String)name).addParam("ExpenseId", (Object)expense.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)expense)).generate().getFileLink();
        this.logger.debug("Printing {}", (Object)name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public String expenseValidateMenuTag() {
        return ((HRMenuTagService)Beans.get(HRMenuTagService.class)).countRecordsTag(Expense.class, 2);
    }

    public String expenseVentilateMenuTag() {
        Long total = JPA.all(Expense.class).filter("self.statusSelect = 3 AND self.ventilated = false").count();
        return String.format("%s", total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
            expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
            ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
            expenseService.cancel(expense);
            Message message = expenseService.sendCancellationEmail(expense);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void addPayment(ActionRequest request, ActionResponse response) {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
        try {
            ((ExpenseService)Beans.get(ExpenseService.class)).addPayment(expense);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelPayment(ActionRequest request, ActionResponse response) {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
        try {
            ((ExpenseService)Beans.get(ExpenseService.class)).cancelPayment(expense);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
            expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
            ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
            expenseService.confirm(expense);
            Message message = expenseService.sendConfirmationEmail(expense);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void newExpense(ActionResponse response) {
        response.setView(ActionView.define((String)I18n.get((String)"Expense")).model(Expense.class.getName()).add("form", "expense-form").context("_payCompany", (Object)((UserHrService)Beans.get(UserHrService.class)).getPayCompany(AuthUtils.getUser())).map());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valid(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
            expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
            ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
            expenseService.validate(expense);
            Message message = expenseService.sendValidationEmail(expense);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
            expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).find(expense.getId()));
            ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
            expenseService.refuse(expense);
            Message message = expenseService.sendRefusalEmail(expense);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void fillKilometricExpenseProduct(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Expense expense = (Expense)((Object)request.getContext().getParent().asType(Expense.class));
            Product expenseProduct = ((ExpenseService)Beans.get(ExpenseService.class)).getKilometricExpenseProduct(expense);
            this.logger.debug("Get Kilometric expense product : {}", (Object)expenseProduct);
            response.setValue("expenseProduct", (Object)expenseProduct);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateAndCompute(ActionRequest request, ActionResponse response) {
        Expense expense = (Expense)((Object)request.getContext().asType(Expense.class));
        ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
        ArrayList<Integer> expenseLineListId = new ArrayList<Integer>();
        int compt = 0;
        for (ExpenseLine expenseLine : expenseService.getExpenseLineList(expense)) {
            ++compt;
            if (!expenseLine.getExpenseDate().isAfter(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate())) continue;
            expenseLineListId.add(compt);
        }
        try {
            if (!expenseLineListId.isEmpty()) {
                throw new AxelorException(4, I18n.get((String)"Date can't be in the future for line(s) : %s"), new Object[]{expenseLineListId.stream().map(id -> id.toString()).collect(Collectors.joining(","))});
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
        response.setValue("personalExpenseAmount", (Object)expenseService.computePersonalExpenseAmount(expense));
        response.setValue("advanceAmount", (Object)expenseService.computeAdvanceAmount(expense));
        if (expense.getKilometricExpenseLineList() != null && !expense.getKilometricExpenseLineList().isEmpty()) {
            response.setValue("kilometricExpenseLineList", expense.getKilometricExpenseLineList());
        }
        this.compute(request, response);
    }

    public void computeKilometricExpense(ActionRequest request, ActionResponse response) throws AxelorException {
        String userName;
        String userId;
        Expense expense;
        ExpenseLine expenseLine = (ExpenseLine)((Object)request.getContext().asType(ExpenseLine.class));
        if (expenseLine.getKilometricAllowParam() == null || expenseLine.getDistance().compareTo(BigDecimal.ZERO) == 0 || expenseLine.getExpenseDate() == null) {
            return;
        }
        if (expenseLine.getExpense() != null) {
            this.setExpense(request, expenseLine);
        }
        if ((expense = expenseLine.getExpense()) != null && expenseLine.getUser() != null) {
            userId = expense.getUser().getId().toString();
            userName = expense.getUser().getFullName();
        } else {
            userId = ((Expense)((Object)request.getContext().getParent().asType(Expense.class))).getUser().getId().toString();
            userName = ((Expense)((Object)request.getContext().getParent().asType(Expense.class))).getUser().getFullName();
        }
        Employee employee = (Employee)((Object)((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.user.id = ?1", new Object[]{userId}).fetchOne());
        if (employee == null) {
            throw new AxelorException(4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{userName});
        }
        BigDecimal amount = BigDecimal.ZERO;
        try {
            amount = ((KilometricService)Beans.get(KilometricService.class)).computeKilometricExpense(expenseLine, employee);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setValue("totalAmount", (Object)amount);
        response.setValue("untaxedAmount", (Object)amount);
    }

    public void updateKAPOfKilometricAllowance(ActionRequest request, ActionResponse response) throws AxelorException {
        ExpenseLine expenseLine = (ExpenseLine)((Object)request.getContext().asType(ExpenseLine.class));
        if (expenseLine.getExpense() == null) {
            this.setExpense(request, expenseLine);
        }
        try {
            List<KilometricAllowParam> kilometricAllowParamList = ((ExpenseService)Beans.get(ExpenseService.class)).getListOfKilometricAllowParamVehicleFilter(expenseLine);
            if (kilometricAllowParamList == null || kilometricAllowParamList.isEmpty()) {
                response.setAttr("kilometricAllowParam", "domain", (Object)"self.id IN (0)");
            } else {
                response.setAttr("kilometricAllowParam", "domain", (Object)("self.id IN (" + StringTool.getIdListString(kilometricAllowParamList) + ")"));
            }
            KilometricAllowParam currentKilometricAllowParam = expenseLine.getKilometricAllowParam();
            boolean vehicleOk = false;
            if (kilometricAllowParamList != null && kilometricAllowParamList.size() == 1) {
                response.setValue("kilometricAllowParam", (Object)kilometricAllowParamList.get(0));
            } else if (kilometricAllowParamList != null) {
                for (KilometricAllowParam kilometricAllowParam : kilometricAllowParamList) {
                    if (currentKilometricAllowParam == null || !currentKilometricAllowParam.equals((Object)kilometricAllowParam)) continue;
                    expenseLine.setKilometricAllowParam(kilometricAllowParam);
                    vehicleOk = true;
                    break;
                }
                if (!vehicleOk) {
                    response.setValue("kilometricAllowParam", null);
                } else {
                    response.setValue("kilometricAllowParam", (Object)expenseLine.getKilometricAllowParam());
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private void setExpense(ActionRequest request, ExpenseLine expenseLine) {
        Context parent = request.getContext().getParent();
        if (parent != null && parent.get((Object)"_model").equals(Expense.class.getName())) {
            expenseLine.setExpense((Expense)((Object)parent.asType(Expense.class)));
        }
    }

    public void domainOnSelectOnKAP(ActionRequest request, ActionResponse response) throws AxelorException {
        ExpenseLine expenseLine = (ExpenseLine)((Object)request.getContext().asType(ExpenseLine.class));
        if (expenseLine.getExpense() == null) {
            this.setExpense(request, expenseLine);
        }
        try {
            List<KilometricAllowParam> kilometricAllowParamList = ((ExpenseService)Beans.get(ExpenseService.class)).getListOfKilometricAllowParamVehicleFilter(expenseLine);
            response.setAttr("kilometricAllowParam", "domain", (Object)("self.id IN (" + StringTool.getIdListString(kilometricAllowParamList) + ")"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeDistanceAndKilometricExpense(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Employee employee;
            if (!((AppHumanResourceService)Beans.get(AppHumanResourceService.class)).getAppExpense().getComputeDistanceWithWebService().booleanValue()) {
                return;
            }
            Context context = request.getContext();
            ExpenseLine expenseLine = (ExpenseLine)((Object)context.asType(ExpenseLine.class));
            if (Strings.isNullOrEmpty((String)expenseLine.getFromCity()) || Strings.isNullOrEmpty((String)expenseLine.getToCity())) {
                return;
            }
            KilometricService kilometricService = (KilometricService)Beans.get(KilometricService.class);
            BigDecimal distance = kilometricService.computeDistance(expenseLine);
            expenseLine.setDistance(distance);
            response.setValue("distance", (Object)distance);
            if (expenseLine.getKilometricAllowParam() == null || expenseLine.getExpenseDate() == null || expenseLine.getKilometricTypeSelect() == 0) {
                return;
            }
            Expense expense = expenseLine.getExpense();
            if (expense == null) {
                expense = (Expense)((Object)context.getParent().asType(Expense.class));
            }
            if ((employee = expense.getUser().getEmployee()) == null) {
                throw new AxelorException(4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{expense.getUser().getName()});
            }
            BigDecimal amount = kilometricService.computeKilometricExpense(expenseLine, employee);
            response.setValue("totalAmount", (Object)amount);
            response.setValue("untaxedAmount", (Object)amount);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

