/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.project;

import com.axelor.apps.hr.service.project.ProjectPlanningTimeService;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Singleton
public class ProjectPlanningTimeController {
    public void showPlanning(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Collection users = (Collection)context.get((Object)"userSet");
        String userIds = "";
        if (users != null) {
            for (Map user : users) {
                if (userIds.isEmpty()) {
                    userIds = user.get("id").toString();
                    continue;
                }
                userIds = userIds + "," + user.get("id").toString();
            }
        }
        ActionView.ActionViewBuilder builder = ActionView.define((String)I18n.get((String)"Project Planning time")).model(ProjectPlanningTime.class.getName());
        String url = "project/planning";
        if (!userIds.isEmpty()) {
            url = url + "?userIds=" + userIds;
        }
        builder.add("html", url);
        response.setView(builder.map());
        response.setCanClose(true);
    }

    public void addMultipleProjectPlanningTime(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        ((ProjectPlanningTimeService)Beans.get(ProjectPlanningTimeService.class)).addMultipleProjectPlanningTime((Map<String, Object>)context);
        response.setCanClose(true);
    }

    @Transactional
    public void updateIsIncludeInTuronverForecast(ActionRequest request, ActionResponse response) {
        try {
            ProjectPlanningTime projectPlanningTime = (ProjectPlanningTime)((Object)request.getContext().asType(ProjectPlanningTime.class));
            projectPlanningTime = (ProjectPlanningTime)((Object)((ProjectPlanningTimeRepository)((Object)Beans.get(ProjectPlanningTimeRepository.class))).find(projectPlanningTime.getId()));
            projectPlanningTime.setIsIncludeInTurnoverForecast(projectPlanningTime.getIsIncludeInTurnoverForecast() == false);
            ((ProjectPlanningTimeRepository)((Object)Beans.get(ProjectPlanningTimeRepository.class))).save((Model)((Object)projectPlanningTime));
            response.setValue("isIncludeInTurnoverForecast", (Object)projectPlanningTime.getIsIncludeInTurnoverForecast());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void removeProjectPlanningTime(ActionRequest request, ActionResponse response) {
        List projectPlanningTimeLines = (List)request.getContext().get((Object)"projectPlanningTimeSet");
        if (projectPlanningTimeLines != null) {
            ((ProjectPlanningTimeService)Beans.get(ProjectPlanningTimeService.class)).removeProjectPlanningLines(projectPlanningTimeLines);
        }
        response.setReload(true);
    }
}

