/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.timesheet;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.hr.db.TimesheetReport;
import com.axelor.apps.hr.service.timesheet.TimesheetReportService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimesheetReportController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void printEmployeeTimesheetReport(ActionRequest request, ActionResponse response) throws AxelorException {
        TimesheetReport timesheetReport = (TimesheetReport)((Object)request.getContext().asType(TimesheetReport.class));
        String name = I18n.get((String)"TimesheetReport");
        String fileLink = ReportFactory.createReport((String)"EmployeeTimesheet.rptdesign", (String)name).addParam("TimesheetReportId", (Object)timesheetReport.getId().toString()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("FromDate", (Object)timesheetReport.getFromDate().format(DateTimeFormatter.ofPattern("dd-MM-yyy"))).addParam("ToDate", (Object)timesheetReport.getToDate().format(DateTimeFormatter.ofPattern("dd-MM-yyy"))).toAttach((Model)((Object)timesheetReport)).generate().getFileLink();
        this.logger.debug("Printing {}", (Object)name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void fillTimesheetReportReminderUsers(ActionRequest request, ActionResponse response) {
        TimesheetReport timesheetReport = (TimesheetReport)((Object)request.getContext().asType(TimesheetReport.class));
        Set<User> reminderUserSet = ((TimesheetReportService)Beans.get(TimesheetReportService.class)).getUserToBeReminded(timesheetReport);
        if (!ObjectUtils.isEmpty(reminderUserSet)) {
            response.setValue("reminderUserSet", reminderUserSet);
        } else {
            response.setValue("reminderUserSet", null);
            response.setNotify(I18n.get((String)"No user found"));
        }
    }

    public void sendTimesheetReminder(ActionRequest request, ActionResponse response) throws AxelorException {
        TimesheetReport timesheetReport = (TimesheetReport)((Object)request.getContext().asType(TimesheetReport.class));
        if (ObjectUtils.isEmpty(timesheetReport.getReminderUserSet())) {
            return;
        }
        List<Message> messages = ((TimesheetReportService)Beans.get(TimesheetReportService.class)).sendReminders(timesheetReport);
        ArrayList<Long> messageIds = new ArrayList<Long>();
        messageIds.add(0L);
        for (Message message : messages) {
            messageIds.add(message.getId());
        }
        response.setView(ActionView.define((String)I18n.get((String)"Messages")).model(Message.class.getName()).add("grid", "message-timesheet-reminder-grid").add("form", "message-form").domain("self.id in (:messageIds)").context("messageIds", messageIds).map());
    }
}

