/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.timesheet.timer;

import com.axelor.apps.hr.db.TSTimer;
import com.axelor.apps.hr.db.repo.TSTimerRepository;
import com.axelor.apps.hr.service.timesheet.timer.TimesheetTimerService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class TSTimerController {
    public void editTimesheetTimer(ActionRequest request, ActionResponse response) {
        TSTimer tsTimer = ((TimesheetTimerService)Beans.get(TimesheetTimerService.class)).getCurrentTSTimer();
        if (tsTimer == null) {
            response.setView(ActionView.define((String)I18n.get((String)"TSTimer")).model(TSTimer.class.getName()).add("form", "ts-timer-form").map());
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"TSTimer")).model(TSTimer.class.getName()).add("form", "ts-timer-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(tsTimer.getId())).map());
        }
    }

    public void editTimesheetTimerFromTimesheet(ActionRequest request, ActionResponse response) {
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"TSTimer")).model(TSTimer.class.getName()).add("form", "ts-timer-form").param("popup", "reload").param("forceEdit", "true").param("width", "800").param("show-confirm", "true").param("show-toolbar", "false").param("popup-save", "true");
        TSTimer tsTimer = ((TimesheetTimerService)Beans.get(TimesheetTimerService.class)).getCurrentTSTimer();
        if (tsTimer != null) {
            actionView.context("_showRecord", (Object)String.valueOf(tsTimer.getId()));
        }
        response.setView(actionView.map());
    }

    public void pause(ActionRequest request, ActionResponse response) {
        try {
            TSTimer timerView = (TSTimer)((Object)request.getContext().asType(TSTimer.class));
            TSTimer timer = (TSTimer)((Object)((TSTimerRepository)((Object)Beans.get(TSTimerRepository.class))).find(timerView.getId()));
            ((TimesheetTimerService)Beans.get(TimesheetTimerService.class)).pause(timer);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void stop(ActionRequest request, ActionResponse response) {
        try {
            TSTimer timerView = (TSTimer)((Object)request.getContext().asType(TSTimer.class));
            TSTimer timer = (TSTimer)((Object)((TSTimerRepository)((Object)Beans.get(TSTimerRepository.class))).find(timerView.getId()));
            ((TimesheetTimerService)Beans.get(TimesheetTimerService.class)).stop(timer);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

