/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool;

import com.axelor.apps.tool.date.DateTool;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecimalTool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static BigDecimal prorata(LocalDate fromDate, LocalDate toDate, LocalDate date, BigDecimal value, int scale) {
        BigDecimal prorataValue = BigDecimal.ZERO;
        if (fromDate == null || toDate == null || date == null) {
            return prorataValue;
        }
        BigDecimal totalDays = new BigDecimal(DateTool.daysBetween(fromDate, toDate, false));
        BigDecimal days = new BigDecimal(DateTool.daysBetween(date, toDate, false));
        prorataValue = DecimalTool.prorata(totalDays, days, value, scale);
        LOG.debug("Proratisation ({} pour {} \u00e0 {}) \u00e0 la date du {} : {}", new Object[]{value, fromDate, toDate, date, prorataValue});
        return prorataValue;
    }

    public static BigDecimal prorata(BigDecimal totalDays, BigDecimal days, BigDecimal value, int scale) {
        BigDecimal prorataValue = BigDecimal.ZERO;
        if (totalDays.compareTo(prorataValue) == 0) {
            return prorataValue;
        }
        prorataValue = days.multiply(value).divide(totalDays, scale, 6).setScale(scale, RoundingMode.HALF_EVEN);
        LOG.debug("Proratisation d'une valeur sur un total de jour {} pour {} jours et une valeur de {} : {}", new Object[]{totalDays, days, value, prorataValue});
        return prorataValue;
    }

    public static BigDecimal prorata(LocalDate fromDate, LocalDate toDate, LocalDate date, BigDecimal value) {
        return DecimalTool.prorata(fromDate, toDate, date, value, 2);
    }

    public static BigDecimal prorata(BigDecimal totalDays, BigDecimal days, BigDecimal value) {
        return DecimalTool.prorata(totalDays, days, value, 2);
    }

    public static BigDecimal percent(BigDecimal value, BigDecimal percent, int scale) {
        return value.multiply(percent).divide(new BigDecimal("100"), scale, RoundingMode.HALF_EVEN);
    }
}

