/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool;

import com.axelor.db.Model;
import com.axelor.db.Query;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryBuilder<T extends Model> {
    private final List<String> filterList = new ArrayList<String>();
    private final Map<String, Object> bindingMap = new HashMap<String, Object>();
    private final Class<T> modelClass;

    private QueryBuilder(Class<T> modelClass) {
        this.modelClass = modelClass;
    }

    public static <T extends Model> QueryBuilder<T> of(Class<T> modelClass) {
        return new QueryBuilder<T>(modelClass);
    }

    public QueryBuilder<T> add(String filter) {
        this.filterList.add(filter);
        return this;
    }

    public QueryBuilder<T> bind(String name, Object value) {
        this.bindingMap.put(name, value);
        return this;
    }

    public Query<T> build() {
        String filter = Joiner.on((String)" AND ").join((Iterable)Lists.transform(this.filterList, input -> String.format("(%s)", input)));
        Query query = Query.of(this.modelClass).filter(filter);
        for (Map.Entry<String, Object> entry : this.bindingMap.entrySet()) {
            query.bind(entry.getKey(), entry.getValue());
        }
        return query;
    }

    @Deprecated
    public Query<T> create() {
        return this.build();
    }
}

