/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.date;

import com.axelor.apps.tool.date.DateTool;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.time.LocalDate;

@Deprecated
public class Period {
    private LocalDate from;
    private LocalDate to;
    private boolean days360;

    @Inject
    public Period() {
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public void setFrom(LocalDate from) {
        this.from = from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public void setTo(LocalDate to) {
        this.to = to;
    }

    public boolean isDays360() {
        return this.days360;
    }

    public void setDays360(boolean days360) {
        this.days360 = days360;
    }

    public Period(boolean days360) {
        this.days360 = days360;
    }

    public Period(LocalDate from, LocalDate to, boolean days360) {
        this.from = from;
        this.to = to;
        this.days360 = days360;
    }

    public Period(LocalDate from, LocalDate to) {
        this.from = from;
        this.to = to;
        this.days360 = false;
    }

    public Period(Period p) {
        this.from = p.getFrom();
        this.to = p.getTo();
        this.days360 = p.isDays360();
    }

    public long getDays() {
        return DateTool.daysBetween(this.from, this.to, this.days360);
    }

    public long getMonths() {
        if (this.days360) {
            return DateTool.days360MonthsBetween(this.from, this.to);
        }
        return java.time.Period.between(this.from, this.to).getMonths();
    }

    public Period prorata(Period period) {
        return this.prorata(period.getFrom(), period.getTo());
    }

    public Period prorata(LocalDate date1, LocalDate date2) {
        Period p = null;
        if (DateTool.isProrata(this.from, this.to, date1, date2)) {
            p = new Period(this);
            if (date1.isAfter(this.from)) {
                p.setFrom(date1);
            }
            if (date2 != null && date2.isBefore(this.to)) {
                p.setTo(date2);
            }
        }
        return p;
    }

    public boolean isProrata(Period period) {
        return DateTool.isProrata(this.from, this.to, period.getFrom(), period.getTo());
    }

    public boolean fromBetween(LocalDate date1, LocalDate date2) {
        return DateTool.isBetween(date1, date2, this.from);
    }

    public boolean toBetween(LocalDate date1, LocalDate date2) {
        return DateTool.isBetween(date1, date2, this.to);
    }

    public boolean contains(LocalDate date) {
        return DateTool.isBetween(this.from, this.to, date);
    }

    public boolean isNotNull() {
        return this.getFrom() != null && this.getTo() != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Period) {
            Period period = (Period)obj;
            return this.from.equals(period.getFrom()) && this.to.equals(period.getTo()) && this.days360 == period.isDays360();
        }
        return false;
    }

    public int hashCode() {
        if (this.days360) {
            return this.from.hashCode() ^ this.to.hashCode();
        }
        return this.from.hashCode() ^ this.to.hashCode() * -1;
    }

    public String toString() {
        return this.from + " - " + this.to + "(" + I18n.get((String)"Years in 360 days") + " :" + this.days360 + ")";
    }
}

