/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.file;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public final class CsvTool {
    private CsvTool() {
    }

    public static List<String[]> cSVFileReader(String fileName, char separator) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(fileName), separator);
        List myEntries = reader.readAll();
        reader.close();
        return myEntries;
    }

    public static CSVWriter setCsvFile(String filePath, String fileName, char separator) throws IOException {
        FileWriter w = new FileWriter(filePath + File.separator + fileName);
        return new CSVWriter((Writer)w, separator, '\u0000', "\r\n");
    }

    public static CSVWriter setCsvFile(String filePath, String fileName, char separator, char quoteChar) throws IOException {
        FileWriter w = new FileWriter(filePath + File.separator + fileName);
        return new CSVWriter((Writer)w, separator, quoteChar, "\r\n");
    }

    public static void csvWriter(String filePath, String fileName, char separator, String[] headers, List<String[]> dataList) throws IOException {
        CSVWriter reconWriter = CsvTool.setCsvFile(filePath, fileName, separator);
        if (headers != null) {
            reconWriter.writeNext(headers);
        }
        reconWriter.writeAll(dataList);
        reconWriter.flush();
        try {
            reconWriter.close();
        }
        catch (IOException e) {
            reconWriter = null;
        }
    }

    public static void csvWriter(String filePath, String fileName, char separator, char quoteChar, String[] headers, List<String[]> dataList) throws IOException {
        CSVWriter reconWriter = CsvTool.setCsvFile(filePath, fileName, separator, quoteChar);
        if (headers != null) {
            reconWriter.writeNext(headers);
        }
        reconWriter.writeAll(dataList);
        reconWriter.flush();
        try {
            reconWriter.close();
        }
        catch (IOException e) {
            reconWriter = null;
        }
    }
}

