/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private FileTool() {
    }

    public static List<String> reader(String fileName) throws IOException {
        ArrayList<String> content = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));){
            String ligne = "";
            while ((ligne = br.readLine()) != null) {
                content.add(ligne);
            }
        }
        return content;
    }

    public static void writer(String destinationFolder, String fileName, String line) throws IOException {
        System.setProperty("line.separator", "\r\n");
        File file = FileTool.create(destinationFolder, fileName);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(line);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
    }

    public static File writer(String destinationFolder, String fileName, List<String> multiLine) throws IOException {
        System.setProperty("line.separator", "\r\n");
        File file = FileTool.create(destinationFolder, fileName);
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            int i = 0;
            for (String line : multiLine) {
                output.write(line);
                output.newLine();
                if (++i % 50 != 0) continue;
                output.flush();
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
        return file;
    }

    public static File create(String fileName) {
        String[] filePath = fileName.split(Pattern.quote(File.separator));
        String name = filePath[filePath.length - 1];
        return FileTool.create(fileName.replace(name, ""), name);
    }

    public static File create(String destinationFolder, String fileName) {
        File folder = new File(destinationFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return new File(folder, fileName);
    }

    public static void copy(String fileSrc, String fileDest) throws IOException {
        IOUtils.copy((InputStream)new FileInputStream(fileSrc), (OutputStream)new FileOutputStream(fileDest));
    }

    public static void copyFolderToFolder(String sourceFolder, String destinationFolder) throws IOException {
        File[] list;
        File current = new File(sourceFolder);
        File destFile = new File(destinationFolder);
        if (!destFile.exists()) {
            destFile.mkdir();
        }
        if (current.isDirectory() && (list = current.listFiles()) != null) {
            for (int i = 0; i < list.length; ++i) {
                File tf = new File(sourceFolder + File.separator + list[i].getName());
                File pf = new File(destinationFolder + File.separator + list[i].getName());
                if (tf.isDirectory() && !pf.exists()) {
                    pf.mkdir();
                    FileTool.copyFolderToFolder(tf.getAbsolutePath(), pf.getAbsolutePath());
                    continue;
                }
                if (tf.isDirectory() && pf.exists()) {
                    FileTool.copyFolderToFolder(tf.getAbsolutePath(), pf.getAbsolutePath());
                    continue;
                }
                if (tf.isFile()) {
                    FileTool.copy(sourceFolder + File.separator + list[i].getName(), destinationFolder + File.separator + list[i].getName());
                    continue;
                }
                LOG.error("Error : Copy folder");
            }
        }
    }
}

