/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.net;

import com.axelor.exception.service.TraceBackService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MyFtp {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private MyFtp() {
    }

    public static void getDataFiles(String server, String username, String password, String folder, String destinationFolder, Calendar start, Calendar end) {
        try {
            FTPClient ftp = new FTPClient();
            ftp.connect(server);
            ftp.login(username, password);
            ftp.changeWorkingDirectory(folder);
            FTPFile[] files = ftp.listFiles();
            MyFtp.getDataFile(files, destinationFolder, start, end, ftp);
            ftp.logout();
            ftp.disconnect();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public static void getDataFile(FTPFile[] files, String destinationFolder, Calendar start, Calendar end, FTPClient ftp) {
        for (int i = 0; i < files.length; ++i) {
            Date fileDate = files[i].getTimestamp().getTime();
            if (fileDate.compareTo(start.getTime()) < 0 || fileDate.compareTo(end.getTime()) > 0) continue;
            File file = new File(destinationFolder + File.separator + files[i].getName());
            try (FileOutputStream fos = new FileOutputStream(file);){
                ftp.retrieveFile(files[i].getName(), (OutputStream)fos);
                file.setLastModified(fileDate.getTime());
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                TraceBackService.trace((Throwable)e);
            }
        }
    }
}

