/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.net;

import com.axelor.apps.tool.file.FileTool;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLService {
    static final int size = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String notExist(String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            return I18n.get((String)"Can not opening the connection to a empty URL.");
        }
        try {
            URL fileURL = new URL(url);
            fileURL.openConnection().connect();
            return null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return String.format(I18n.get((String)"Url %s is malformed."), url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return String.format(I18n.get((String)"An error occurs while opening the connection. Please verify the following URL : %s."), url);
        }
    }

    public static void fileUrl(File file, String fAddress, String localFileName, String destinationDir) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
            int byteRead;
            int byteWritten = 0;
            byte[] buf = new byte[1024];
            URL url = new URL(fAddress);
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            while ((byteRead = inputStream.read(buf)) != -1) {
                ((OutputStream)outputStream).write(buf, 0, byteRead);
                byteWritten += byteRead;
            }
            LOG.info("Downloaded Successfully.");
            LOG.debug("No of bytes", (Object)byteWritten);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
    }

    public static File fileDownload(String fAddress, String destinationDir, String fileName) throws IOException {
        int slashIndex = fAddress.lastIndexOf(47);
        int periodIndex = fAddress.lastIndexOf(46);
        if (periodIndex >= 1 && slashIndex >= 0 && slashIndex < fAddress.length() - 1) {
            LOG.debug("Downloading file {} from {} to {}", new Object[]{fileName, fAddress, destinationDir});
            File file = FileTool.create(destinationDir, fileName);
            URLService.fileUrl(file, fAddress, fileName, destinationDir);
            return file;
        }
        LOG.error("Destination path or filename is not well formatted.");
        return null;
    }

    public static void fileDownload(File file, String fAddress, String destinationDir, String fileName) throws IOException {
        int slashIndex = fAddress.lastIndexOf(47);
        int periodIndex = fAddress.lastIndexOf(46);
        if (periodIndex >= 1 && slashIndex >= 0 && slashIndex < fAddress.length() - 1) {
            LOG.debug("Downloading file {} from {} to {}", new Object[]{fileName, fAddress, destinationDir});
            URLService.fileUrl(file, fAddress, fileName, destinationDir);
        } else {
            LOG.error("Destination path or filename is not well formatted.");
        }
    }
}

