/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.tool.service;

import com.axelor.app.AppSettings;
import com.axelor.apps.tool.service.CipherService;
import com.axelor.common.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class CipherServiceImpl
implements CipherService {
    private static final String UNICODE_FORMAT = "UTF8";
    public static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private Cipher cipher;

    @Override
    public String encrypt(String unencryptedString) {
        String encryptedString = null;
        try {
            SecretKey key = this.initEncryptOrDecrypt();
            if (key == null) {
                return unencryptedString;
            }
            this.cipher.init(1, key);
            byte[] plainText = unencryptedString.getBytes(UNICODE_FORMAT);
            byte[] encryptedText = this.cipher.doFinal(plainText);
            encryptedString = Base64.getEncoder().encodeToString(encryptedText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    @Override
    public String decrypt(String encryptedString) {
        String decryptedText = null;
        try {
            SecretKey key = this.initEncryptOrDecrypt();
            if (key == null) {
                return encryptedString;
            }
            this.cipher.init(2, key);
            byte[] encryptedText = Base64.getDecoder().decode(encryptedString);
            byte[] plainText = this.cipher.doFinal(encryptedText);
            decryptedText = new String(plainText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptedText;
    }

    private SecretKey initEncryptOrDecrypt() throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        String encryptionScheme = DESEDE_ENCRYPTION_SCHEME;
        String encryptionkey = AppSettings.get().get("application.encryptionkey");
        SecretKey key = null;
        if (StringUtils.notEmpty((CharSequence)encryptionkey)) {
            byte[] arrayBytes = encryptionkey.getBytes(UNICODE_FORMAT);
            DESedeKeySpec ks = new DESedeKeySpec(arrayBytes);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
            key = skf.generateSecret(ks);
        }
        return key;
    }
}

