/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLIERMANAGEMENT_PURCHASE_ORDER_SUPPLIER_LINE", indexes={@Index(name="idx_suppmanage_po_supp_line_po_line", columnList="purchase_order_line"), @Index(name="idx_suppmanage_po_supp_line_supp_partner", columnList="supplier_partner")})
public class PurchaseOrderSupplierLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLIERMANAGEMENT_PURCHASE_ORDER_SUPPLIER_LINE_SEQ")
    @SequenceGenerator(name="SUPPLIERMANAGEMENT_PURCHASE_ORDER_SUPPLIER_LINE_SEQ", sequenceName="SUPPLIERMANAGEMENT_PURCHASE_ORDER_SUPPLIER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Purchase order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrderLine purchaseOrderLine;
    @Widget(title="Available qty")
    private BigDecimal availableQty = new BigDecimal("0");
    @Widget(title="Unit price")
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Estim. delivery date")
    private LocalDate estimatedDelivDate;
    @Widget(title="State", selection="isuppliermanagement.purchase.order.supplier.line.state.select")
    private Integer stateSelect = 0;
    @Widget(title="Supplier")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner supplierPartner;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PurchaseOrderSupplierLine() {
    }

    public PurchaseOrderSupplierLine(BigDecimal price, Integer stateSelect, Partner supplierPartner) {
        this.price = price;
        this.stateSelect = stateSelect;
        this.supplierPartner = supplierPartner;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PurchaseOrderLine getPurchaseOrderLine() {
        return this.purchaseOrderLine;
    }

    public void setPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        this.purchaseOrderLine = purchaseOrderLine;
    }

    public BigDecimal getAvailableQty() {
        return this.availableQty == null ? BigDecimal.ZERO : this.availableQty;
    }

    public void setAvailableQty(BigDecimal availableQty) {
        this.availableQty = availableQty;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public LocalDate getEstimatedDelivDate() {
        return this.estimatedDelivDate;
    }

    public void setEstimatedDelivDate(LocalDate estimatedDelivDate) {
        this.estimatedDelivDate = estimatedDelivDate;
    }

    public Integer getStateSelect() {
        return this.stateSelect == null ? 0 : this.stateSelect;
    }

    public void setStateSelect(Integer stateSelect) {
        this.stateSelect = stateSelect;
    }

    public Partner getSupplierPartner() {
        return this.supplierPartner;
    }

    public void setSupplierPartner(Partner supplierPartner) {
        this.supplierPartner = supplierPartner;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PurchaseOrderSupplierLine)) {
            return false;
        }
        PurchaseOrderSupplierLine other = (PurchaseOrderSupplierLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("availableQty", (Object)this.getAvailableQty()).add("price", (Object)this.getPrice()).add("estimatedDelivDate", (Object)this.getEstimatedDelivDate()).add("stateSelect", (Object)this.getStateSelect()).omitNullValues().toString();
    }
}

