/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.service.PurchaseOrderLineServiceImpl;
import com.axelor.apps.suppliermanagement.db.PurchaseOrderSupplierLine;
import com.axelor.apps.suppliermanagement.db.repo.PurchaseOrderSupplierLineRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class PurchaseOrderSupplierLineService {
    @Inject
    PurchaseOrderSupplierLineRepository poSupplierLineRepo;

    @Transactional(rollbackOn={Exception.class})
    public void accept(PurchaseOrderSupplierLine purchaseOrderSupplierLine) throws AxelorException {
        PurchaseOrderLine purchaseOrderLine = purchaseOrderSupplierLine.getPurchaseOrderLine();
        purchaseOrderLine.setEstimatedDelivDate(purchaseOrderSupplierLine.getEstimatedDelivDate());
        Partner supplierPartner = purchaseOrderSupplierLine.getSupplierPartner();
        Company company = purchaseOrderLine.getPurchaseOrder().getCompany();
        if (((BlockingService)Beans.get(BlockingService.class)).getBlocking(supplierPartner, company, 6) != null) {
            throw new AxelorException(1, I18n.get((String)"This supplier is blocked:"), new Object[]{supplierPartner});
        }
        purchaseOrderLine.setSupplierPartner(supplierPartner);
        purchaseOrderLine.setPrice(purchaseOrderSupplierLine.getPrice());
        purchaseOrderLine.setExTaxTotal(PurchaseOrderLineServiceImpl.computeAmount((BigDecimal)purchaseOrderLine.getQty(), (BigDecimal)purchaseOrderLine.getPrice()));
        purchaseOrderSupplierLine.setStateSelect(3);
        this.poSupplierLineRepo.save((Model)((Object)purchaseOrderSupplierLine));
    }

    public PurchaseOrderSupplierLine create(Partner supplierPartner, BigDecimal price) {
        return new PurchaseOrderSupplierLine(price, 1, supplierPartner);
    }
}

